/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.messaging.Message;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;

public class MarshallingWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, @Nullable Unmarshaller unmarshaller, @Nullable WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        this.configureMarshallers(marshaller, unmarshaller);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller) {
        this(destinationProvider, marshaller, unmarshaller, null);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, @Nullable WebServiceMessageFactory messageFactory) {
        this(destinationProvider, marshaller, null, messageFactory);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller) {
        this(destinationProvider, marshaller, (WebServiceMessageFactory)null);
    }

    public MarshallingWebServiceOutboundGateway(@Nullable String uri, Marshaller marshaller, @Nullable Unmarshaller unmarshaller, @Nullable WebServiceMessageFactory messageFactory) {
        super(uri, messageFactory);
        this.configureMarshallers(marshaller, unmarshaller);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller, Unmarshaller unmarshaller) {
        this(uri, marshaller, unmarshaller, null);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller, @Nullable WebServiceMessageFactory messageFactory) {
        this(uri, marshaller, null, messageFactory);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller) {
        this(uri, marshaller, (WebServiceMessageFactory)null);
    }

    public MarshallingWebServiceOutboundGateway(@Nullable String uri, WebServiceTemplate webServiceTemplate) {
        super(uri, null);
        this.doSetWebServiceTemplate(webServiceTemplate);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, WebServiceTemplate webServiceTemplate) {
        super(destinationProvider, null);
        this.doSetWebServiceTemplate(webServiceTemplate);
    }

    private void configureMarshallers(Marshaller marshaller, @Nullable Unmarshaller unmarshallerArg) {
        Unmarshaller unmarshaller = unmarshallerArg;
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (unmarshaller == null) {
            Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller, (String)("Marshaller [" + String.valueOf(marshaller) + "] does not implement the Unmarshaller interface. Please set an Unmarshaller explicitly by using one of the constructors that accepts both Marshaller and Unmarshaller arguments."));
            unmarshaller = (Unmarshaller)marshaller;
        }
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.getWebServiceTemplate().setMarshaller(marshaller);
        this.getWebServiceTemplate().setUnmarshaller(unmarshaller);
    }

    public String getComponentType() {
        return "ws:outbound-gateway(marshalling)";
    }

    @Override
    protected @Nullable Object doHandle(String uri, Message<?> requestMessage, @Nullable WebServiceMessageCallback requestCallback) {
        return this.getWebServiceTemplate().marshalSendAndReceive(uri, requestMessage.getPayload(), (WebServiceMessageCallback)new PassThroughRequestMessageCallback(requestCallback, requestMessage));
    }

    private final class PassThroughRequestMessageCallback
    extends AbstractWebServiceOutboundGateway.RequestMessageCallback {
        PassThroughRequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            super(MarshallingWebServiceOutboundGateway.this, requestCallback, requestMessage);
        }

        @Override
        public void doWithMessageInternal(WebServiceMessage message, Object payload) throws IOException {
        }
    }
}

