/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceInboundGateway
extends MessagingGatewaySupport
implements MessageEndpoint {
    private final TransformerSupportDelegate transformerSupportDelegate = new TransformerSupportDelegate();
    private volatile boolean extractPayload = true;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void invoke(MessageContext messageContext) throws Exception {
        try {
            this.doInvoke(messageContext);
        }
        catch (Exception e) {
            while ((e instanceof MessagingException || e instanceof ExpressionException) && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    private void doInvoke(MessageContext messageContext) throws Exception {
        Message replyMessage;
        SoapMessage soapMessage;
        SoapHeader soapHeader;
        Assert.notNull((Object)messageContext, (String)"'messageContext' is required; it must not be null.");
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        MessageBuilder builder = MessageBuilder.withPayload((Object)(this.extractPayload ? request.getPayloadSource() : request));
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                builder.setHeader(propertyName, messageContext.getProperty(propertyName));
            }
        }
        if (request instanceof SoapMessage && (soapHeader = (soapMessage = (SoapMessage)request).getSoapHeader()) != null) {
            Iterator attributeIter = soapHeader.getAllAttributes();
            while (attributeIter.hasNext()) {
                QName name = (QName)attributeIter.next();
                builder.setHeader(name.toString(), (Object)soapHeader.getAttributeValue(name));
            }
            Iterator elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                Object element = elementIter.next();
                if (!(element instanceof SoapHeaderElement)) continue;
                QName name = ((SoapHeaderElement)element).getName();
                builder.setHeader(name.toString(), element);
            }
        }
        if ((replyMessage = this.sendAndReceiveMessage(builder.build())) != null && replyMessage.getPayload() != null) {
            Object replyPayload = replyMessage.getPayload();
            Source responseSource = null;
            if (replyPayload instanceof Source) {
                responseSource = (Source)replyPayload;
            } else if (replyPayload instanceof Document) {
                responseSource = new DOMSource((Document)replyPayload);
            } else if (replyPayload instanceof String) {
                responseSource = new StringSource((String)replyPayload);
            } else {
                throw new IllegalArgumentException("The reply Message payload must be a [" + Source.class.getName() + "], [" + Document.class.getName() + "], or [java.lang.String]. The actual type was [" + replyPayload.getClass().getName() + "]");
            }
            WebServiceMessage response = messageContext.getResponse();
            this.transformerSupportDelegate.transformSourceToResult(responseSource, response.getPayloadResult());
        }
    }

    private class TransformerSupportDelegate
    extends TransformerObjectSupport {
        private TransformerSupportDelegate() {
        }

        void transformSourceToResult(Source source, Result result) throws TransformerException {
            this.transform(source, result);
        }
    }
}

