/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.websocket.ServerWebSocketContainer;
import org.springframework.integration.websocket.config.IntegrationDynamicWebSocketHandlerMapping;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistry;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

class IntegrationServletWebSocketHandlerRegistry
extends ServletWebSocketHandlerRegistry
implements ApplicationContextAware,
DestructionAwareBeanPostProcessor {
    private final Map<WebSocketHandler, List<String>> dynamicRegistrations = new HashMap<WebSocketHandler, List<String>>();
    private ApplicationContext applicationContext;
    private volatile IntegrationDynamicWebSocketHandlerMapping dynamicHandlerMapping;

    IntegrationServletWebSocketHandlerRegistry() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected boolean requiresTaskScheduler() {
        return super.requiresTaskScheduler();
    }

    protected void setTaskScheduler(TaskScheduler scheduler) {
        super.setTaskScheduler(scheduler);
    }

    public AbstractHandlerMapping getHandlerMapping() {
        AbstractHandlerMapping originHandlerMapping = super.getHandlerMapping();
        originHandlerMapping.setApplicationContext(this.applicationContext);
        this.dynamicHandlerMapping = (IntegrationDynamicWebSocketHandlerMapping)((Object)this.applicationContext.getBean(IntegrationDynamicWebSocketHandlerMapping.class));
        return originHandlerMapping;
    }

    public WebSocketHandlerRegistration addHandler(WebSocketHandler handler, String ... paths) {
        if (this.dynamicHandlerMapping != null) {
            IntegrationDynamicWebSocketHandlerRegistration registration = new IntegrationDynamicWebSocketHandlerRegistration();
            registration.addHandler(handler, paths);
            MultiValueMap<HttpRequestHandler, String> mappings = registration.getMapping();
            for (Map.Entry entry : mappings.entrySet()) {
                HttpRequestHandler httpHandler = (HttpRequestHandler)entry.getKey();
                List patterns = (List)entry.getValue();
                this.dynamicRegistrations.put(handler, patterns);
                for (String pattern : patterns) {
                    this.dynamicHandlerMapping.registerHandler(pattern, httpHandler);
                }
            }
            return registration;
        }
        return super.addHandler(handler, paths);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.dynamicHandlerMapping != null && bean instanceof ServerWebSocketContainer) {
            ((ServerWebSocketContainer)bean).registerWebSocketHandlers((WebSocketHandlerRegistry)this);
        }
        return bean;
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof ServerWebSocketContainer;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.requiresDestruction(bean)) {
            this.removeRegistration((ServerWebSocketContainer)bean);
        }
    }

    void removeRegistration(ServerWebSocketContainer serverWebSocketContainer) {
        List<String> patterns = this.dynamicRegistrations.remove(serverWebSocketContainer.getWebSocketHandler());
        if (this.dynamicHandlerMapping != null && !CollectionUtils.isEmpty(patterns)) {
            for (String pattern : patterns) {
                this.dynamicHandlerMapping.unregisterHandler(pattern);
            }
        }
    }

    private static final class IntegrationDynamicWebSocketHandlerRegistration
    extends ServletWebSocketHandlerRegistration {
        private IntegrationDynamicWebSocketHandlerRegistration() {
        }

        MultiValueMap<HttpRequestHandler, String> getMapping() {
            return (MultiValueMap)this.getMappings();
        }
    }
}

