/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.websocket.support.SubProtocolHandlerRegistry;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class WebSocketAdapterParsingUtils {
    WebSocketAdapterParsingUtils() {
    }

    static void configureWebSocketAdapter(BeanDefinitionBuilder builder, ParserContext parserContext, Element element) {
        String messageConverters;
        String container = element.getAttribute("container");
        if (!StringUtils.hasText((String)container)) {
            parserContext.getReaderContext().error("The 'container' is required", (Object)element);
        }
        builder.addConstructorArgReference(container);
        String protocolHandlers = element.getAttribute("protocol-handlers");
        boolean hasProtocolHandlers = StringUtils.hasText((String)protocolHandlers);
        String defaultProtocolHandler = element.getAttribute("default-protocol-handler");
        boolean hasDefaultProtocolHandler = StringUtils.hasText((String)defaultProtocolHandler);
        if (hasProtocolHandlers || hasDefaultProtocolHandler) {
            String[] ids;
            ManagedList protocolHandlerList = new ManagedList();
            for (String id : ids = StringUtils.commaDelimitedListToStringArray((String)protocolHandlers)) {
                protocolHandlerList.add(new RuntimeBeanReference(id));
            }
            BeanDefinitionBuilder protocolHandlerRegistryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SubProtocolHandlerRegistry.class).addConstructorArgValue((Object)protocolHandlerList);
            if (hasDefaultProtocolHandler) {
                protocolHandlerRegistryBuilder.addConstructorArgReference(defaultProtocolHandler);
            }
            builder.addConstructorArgValue((Object)protocolHandlerRegistryBuilder.getBeanDefinition());
        }
        if (StringUtils.hasText((String)(messageConverters = element.getAttribute("message-converters")))) {
            String[] ids;
            ManagedList messageConverterList = new ManagedList();
            for (String id : ids = StringUtils.commaDelimitedListToStringArray((String)messageConverters)) {
                messageConverterList.add(new RuntimeBeanReference(id));
            }
            builder.addPropertyValue("messageConverters", (Object)messageConverterList);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"merge-with-default-converters");
    }
}

