/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.json.JacksonJsonUtils;
import org.springframework.integration.websocket.ClientWebSocketContainer;
import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.integration.websocket.support.PassThruSubProtocolHandler;
import org.springframework.integration.websocket.support.SubProtocolHandlerRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.SessionLimitExceededException;

public class WebSocketOutboundMessageHandler
extends AbstractMessageHandler {
    private final List<MessageConverter> defaultConverters = new ArrayList<MessageConverter>(3);
    private final CompositeMessageConverter messageConverter;
    private final IntegrationWebSocketContainer webSocketContainer;
    private final SubProtocolHandlerRegistry subProtocolHandlerRegistry;
    private final boolean client;
    private volatile List<MessageConverter> messageConverters;
    private volatile boolean mergeWithDefaultConverters;

    public WebSocketOutboundMessageHandler(IntegrationWebSocketContainer webSocketContainer) {
        this(webSocketContainer, new SubProtocolHandlerRegistry(new PassThruSubProtocolHandler()));
    }

    public WebSocketOutboundMessageHandler(IntegrationWebSocketContainer webSocketContainer, SubProtocolHandlerRegistry protocolHandlerRegistry) {
        this.defaultConverters.add((MessageConverter)new StringMessageConverter());
        this.defaultConverters.add((MessageConverter)new ByteArrayMessageConverter());
        if (JacksonJsonUtils.isJackson2Present()) {
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            this.defaultConverters.add((MessageConverter)converter);
        }
        this.messageConverter = new CompositeMessageConverter(this.defaultConverters);
        this.mergeWithDefaultConverters = false;
        Assert.notNull((Object)webSocketContainer, (String)"'webSocketContainer' must not be null");
        Assert.notNull((Object)protocolHandlerRegistry, (String)"'protocolHandlerRegistry' must not be null");
        this.webSocketContainer = webSocketContainer;
        this.client = webSocketContainer instanceof ClientWebSocketContainer;
        this.subProtocolHandlerRegistry = protocolHandlerRegistry;
        List<String> subProtocols = protocolHandlerRegistry.getSubProtocols();
        this.webSocketContainer.addSupportedProtocols(subProtocols.toArray(new String[subProtocols.size()]));
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        this.messageConverters = new ArrayList<MessageConverter>(messageConverters);
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public String getComponentType() {
        return "websocket:outbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (!CollectionUtils.isEmpty(this.messageConverters)) {
            List converters = this.messageConverter.getConverters();
            if (this.mergeWithDefaultConverters) {
                ListIterator<MessageConverter> iterator = this.messageConverters.listIterator(this.messageConverters.size());
                while (iterator.hasPrevious()) {
                    MessageConverter converter = iterator.previous();
                    converters.add(0, converter);
                }
            } else {
                converters.clear();
                converters.addAll(this.messageConverters);
            }
        }
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String sessionId = null;
        if (!this.client && (sessionId = this.subProtocolHandlerRegistry.resolveSessionId(message)) == null) {
            throw new IllegalArgumentException("The WebSocket 'sessionId' is required in the MessageHeaders");
        }
        WebSocketSession session = this.webSocketContainer.getSession(sessionId);
        try {
            SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
            headers.setLeaveMutable(true);
            headers.setMessageTypeIfNotSet(SimpMessageType.MESSAGE);
            Message messageToSend = this.messageConverter.toMessage(message.getPayload(), headers.getMessageHeaders());
            this.subProtocolHandlerRegistry.findProtocolHandler(session).handleMessageToClient(session, messageToSend);
        }
        catch (SessionLimitExceededException ex) {
            try {
                this.logger.error((Object)("Terminating session id '" + sessionId + "'"), (Throwable)ex);
                this.webSocketContainer.closeSession(session, ex.getStatus());
            }
            catch (Exception secondException) {
                this.logger.error((Object)("Exception terminating session id '" + sessionId + "'"), (Throwable)secondException);
            }
        }
    }
}

