/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.outbound;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFluxRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private final WebClient webClient;
    private boolean replyPayloadToFlux;
    private BodyExtractor<?, ClientHttpResponse> bodyExtractor;

    public WebFluxRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public WebFluxRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public WebFluxRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public WebFluxRequestExecutingMessageHandler(String uri, WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public WebFluxRequestExecutingMessageHandler(Expression uriExpression, WebClient webClient) {
        super(uriExpression);
        this.webClient = webClient == null ? WebClient.create() : webClient;
        this.setAsync(true);
    }

    public void setReplyPayloadToFlux(boolean replyPayloadToFlux) {
        this.replyPayloadToFlux = replyPayloadToFlux;
    }

    public void setBodyExtractor(BodyExtractor<?, ClientHttpResponse> bodyExtractor) {
        this.bodyExtractor = bodyExtractor;
    }

    public String getComponentType() {
        return this.isExpectReply() ? "webflux:outbound-gateway" : "webflux:outbound-channel-adapter";
    }

    protected Object exchange(Supplier<URI> uriSupplier, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage) {
        WebClient.RequestBodySpec requestSpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(httpMethod).uri(b -> (URI)uriSupplier.get())).headers(headers -> headers.putAll((Map)httpRequest.getHeaders()));
        if (httpRequest.hasBody()) {
            requestSpec.body(BodyInserters.fromObject((Object)httpRequest.getBody()));
        }
        Mono responseMono = requestSpec.exchange().flatMap(response -> {
            HttpStatus httpStatus = response.statusCode();
            if (httpStatus.isError()) {
                return ((Flux)response.body(BodyExtractors.toDataBuffers())).reduce((rec$, xva$0) -> ((DataBuffer)rec$).write(new DataBuffer[]{xva$0})).map(dataBuffer -> {
                    byte[] bytes = new byte[dataBuffer.readableByteCount()];
                    dataBuffer.read(bytes);
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                    return bytes;
                }).defaultIfEmpty((Object)new byte[0]).map(bodyBytes -> {
                    throw new WebClientResponseException("ClientResponse has erroneous status code: " + httpStatus.value() + " " + httpStatus.getReasonPhrase(), httpStatus.value(), httpStatus.getReasonPhrase(), response.headers().asHttpHeaders(), bodyBytes, response.headers().contentType().map(MimeType::getCharset).orElse(StandardCharsets.ISO_8859_1));
                });
            }
            return Mono.just((Object)response);
        });
        if (this.isExpectReply()) {
            return responseMono.flatMap(response -> {
                Mono bodyMono;
                ResponseEntity.BodyBuilder httpEntityBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)response.statusCode()).headers(response.headers().asHttpHeaders());
                if (expectedResponseType != null) {
                    if (this.replyPayloadToFlux) {
                        BodyExtractor extractor = expectedResponseType instanceof ParameterizedTypeReference ? BodyExtractors.toFlux((ParameterizedTypeReference)((ParameterizedTypeReference)expectedResponseType)) : BodyExtractors.toFlux((Class)((Class)expectedResponseType));
                        Flux flux = (Flux)response.body(extractor);
                        bodyMono = Mono.just((Object)flux);
                    } else {
                        BodyExtractor extractor = expectedResponseType instanceof ParameterizedTypeReference ? BodyExtractors.toMono((ParameterizedTypeReference)((ParameterizedTypeReference)expectedResponseType)) : BodyExtractors.toMono((Class)((Class)expectedResponseType));
                        bodyMono = (Mono)response.body(extractor);
                    }
                } else {
                    Object body;
                    bodyMono = this.bodyExtractor != null ? ((body = response.body(this.bodyExtractor)) instanceof Mono ? (Mono)body : Mono.just((Object)body)) : Mono.empty();
                }
                return bodyMono.map(arg_0 -> ((ResponseEntity.BodyBuilder)httpEntityBuilder).body(arg_0)).defaultIfEmpty((Object)httpEntityBuilder.build());
            }).map(arg_0 -> ((WebFluxRequestExecutingMessageHandler)this).getReply(arg_0));
        }
        responseMono.subscribe(v -> {}, ex -> this.sendErrorMessage((Message)requestMessage, (Throwable)ex));
        return null;
    }
}

