/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Date;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.springframework.integration.Message;
import org.springframework.integration.test.matcher.MapContentMatchers;
import org.springframework.integration.test.matcher.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderMatcher
extends TypeSafeMatcher<Message<?>> {
    private final Matcher<?> matcher;

    HeaderMatcher(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matchesSafely(Message<?> item) {
        return this.matcher.matches((Object)item.getHeaders());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers containing ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <T> Matcher<Message<?>> hasHeader(String key, T value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry(key, value));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasHeader(String key, Matcher<?> valueMatcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry(key, valueMatcher));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasHeaderKey(String key) {
        return new HeaderMatcher(MapContentMatchers.hasKey(key));
    }

    @Factory
    public static Matcher<Message<?>> hasAllHeaders(Map<String, ?> entries) {
        return new HeaderMatcher(MapContentMatchers.hasAllEntries(entries));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasMessageId(T value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("id", value));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasCorrelationId(T value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("correlationId", value));
    }

    @Factory
    public static Matcher<Message<?>> hasSequenceNumber(Integer value) {
        return HeaderMatcher.hasSequenceNumber((Matcher<Integer>)CoreMatchers.is((Object)value));
    }

    @Factory
    public static Matcher<Message<?>> hasSequenceNumber(Matcher<Integer> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("sequenceNumber", matcher));
    }

    @Factory
    public static Matcher<Message<?>> hasSequenceSize(Integer value) {
        return HeaderMatcher.hasSequenceSize((Matcher<Integer>)CoreMatchers.is((Object)value));
    }

    @Factory
    public static Matcher<Message<?>> hasSequenceSize(Matcher<Integer> value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("sequenceSize", value));
    }

    @Factory
    public static Matcher<Message<?>> hasExpirationDate(Date value) {
        return HeaderMatcher.hasExpirationDate((Matcher<Long>)CoreMatchers.is((Object)value.getTime()));
    }

    @Factory
    public static Matcher<Message<?>> hasExpirationDate(Matcher<Long> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("expirationDate", matcher));
    }

    @Factory
    public static Matcher<Message<?>> hasTimestamp(Date value) {
        return HeaderMatcher.hasTimestamp((Matcher<Long>)CoreMatchers.is((Object)value.getTime()));
    }

    @Factory
    public static Matcher<Message<?>> hasTimestamp(Matcher<Long> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("timestamp", matcher));
    }
}

