/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.support;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.test.support.AbstractResponseValidator;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class RequestResponseScenario {
    private final String inputChannelName;
    private final String outputChannelName;
    private @Nullable Object payload;
    private @Nullable Message<?> message;
    private AbstractResponseValidator<?> responseValidator;
    private @Nullable String name;

    protected Message<?> getMessage() {
        if (this.message == null) {
            return new GenericMessage(Objects.requireNonNull(this.payload));
        }
        return this.message;
    }

    public RequestResponseScenario(String inputChannelName, String outputChannelName) {
        this.inputChannelName = inputChannelName;
        this.outputChannelName = outputChannelName;
    }

    public String getInputChannelName() {
        return this.inputChannelName;
    }

    public String getOutputChannelName() {
        return this.outputChannelName;
    }

    public @Nullable Object getPayload() {
        return this.payload;
    }

    public RequestResponseScenario setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public RequestResponseScenario setName(String name) {
        this.name = name;
        return this;
    }

    public AbstractResponseValidator<?> getResponseValidator() {
        return this.responseValidator;
    }

    public RequestResponseScenario setResponseValidator(AbstractResponseValidator<?> responseValidator) {
        this.responseValidator = responseValidator;
        return this;
    }

    public RequestResponseScenario setMessage(Message<?> message) {
        this.message = message;
        return this;
    }

    protected void init() {
        Assert.state((this.message == null || this.payload == null ? 1 : 0) != 0, (String)"cannot set both message and payload");
        Assert.state((this.responseValidator != null ? 1 : 0) != 0, (String)"A 'responseValidator' must be provided for the 'SubscribableChannel' scenario.");
    }
}

