/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.springframework.messaging.Message;

public class MessageMatcher
extends BaseMatcher<Message<?>> {
    private final Object payload;
    private final Map<String, Object> headers;

    public MessageMatcher(Message<?> operand) {
        this.payload = operand.getPayload();
        this.headers = MessageMatcher.getHeaders(operand);
    }

    public boolean matches(Object arg) {
        Message input = (Message)arg;
        Map<String, Object> inputHeaders = MessageMatcher.getHeaders(input);
        return input.getPayload().equals(this.payload) && inputHeaders.equals(this.headers);
    }

    public void describeTo(Description description) {
        description.appendText("Headers match except ID and timestamp for payload: ").appendValue(this.payload).appendText(" and headers: ").appendValue(this.headers);
    }

    private static Map<String, Object> getHeaders(Message<?> operand) {
        HashMap<String, Object> headersToFilter = new HashMap<String, Object>((Map<String, Object>)operand.getHeaders());
        headersToFilter.remove("id");
        headersToFilter.remove("timestamp");
        return headersToFilter;
    }
}

