/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Map;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.internal.hamcrest.HamcrestArgumentMatcher;
import org.springframework.integration.test.matcher.HeaderMatcher;
import org.springframework.integration.test.matcher.PayloadMatcher;
import org.springframework.messaging.Message;

public class MockitoMessageMatchers {
    private MockitoMessageMatchers() {
    }

    public static <T> Message<?> messageWithPayload(Matcher<? super T> payloadMatcher) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(PayloadMatcher.hasPayload(payloadMatcher)));
    }

    public static <T> Message<?> messageWithPayload(T payload) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(PayloadMatcher.hasPayload(payload)));
    }

    public static Message<?> messageWithHeaderEntry(String key, Object value) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(HeaderMatcher.hasHeader(key, value)));
    }

    public static Message<?> messageWithHeaderKey(String key) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(HeaderMatcher.hasHeaderKey(key)));
    }

    public static <T> Message<?> messageWithHeaderEntry(String key, Matcher<T> valueMatcher) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(HeaderMatcher.hasHeader(key, valueMatcher)));
    }

    public static Message<?> messageWithHeaderEntries(Map<String, ?> entries) {
        return (Message)ArgumentMatchers.argThat((ArgumentMatcher)new HamcrestArgumentMatcher(HeaderMatcher.hasAllHeaders(entries)));
    }
}

