/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ip.config.UdpInboundChannelAdapterParser;
import org.springframework.integration.syslog.config.SyslogReceivingChannelAdapterFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SyslogInboundChannelAdapterParser
extends UdpInboundChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SyslogReceivingChannelAdapterFactoryBean.class);
        String protocol = element.getAttribute("protocol");
        if (!StringUtils.hasText((String)protocol)) {
            protocol = SyslogReceivingChannelAdapterFactoryBean.Protocol.udp.toString();
        }
        builder.addConstructorArgValue((Object)protocol);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"port");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"connection-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"converter");
        Element udpAdapterElement = DomUtils.getChildElementByTagName((Element)element, (String)"udp-attributes");
        if (udpAdapterElement != null) {
            if (StringUtils.hasText((String)element.getAttribute("port"))) {
                parserContext.getReaderContext().error("When child element 'udp-attributes' is present, 'port' must be defined there", (Object)element);
            }
            AbstractBeanDefinition udpAdapterDef = super.doParse(udpAdapterElement, parserContext, channelName);
            builder.addPropertyValue("udpAdapter", (Object)udpAdapterDef);
        }
        builder.addPropertyReference("outputChannel", channelName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel", (String)"errorChannel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout");
        return builder.getBeanDefinition();
    }
}

