/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.config;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.integration.syslog.inbound.TcpSyslogReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.UdpSyslogReceivingChannelAdapter;
import org.springframework.integration.util.JavaUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class SyslogReceivingChannelAdapterFactoryBean
extends AbstractFactoryBean<SyslogReceivingChannelAdapterSupport>
implements SmartLifecycle,
BeanNameAware,
ApplicationEventPublisherAware {
    private volatile SyslogReceivingChannelAdapterSupport syslogAdapter;
    private final Protocol protocol;
    private volatile MessageChannel outputChannel;
    private volatile boolean autoStartup = true;
    private volatile MessageChannel errorChannel;
    private volatile int phase;
    private volatile Long sendTimeout;
    private volatile AbstractServerConnectionFactory connectionFactory;
    private volatile UnicastReceivingChannelAdapter udpAdapter;
    private volatile Integer port;
    private volatile MessageConverter converter;
    private volatile String beanName;
    private volatile ApplicationEventPublisher applicationEventPublisher;

    public SyslogReceivingChannelAdapterFactoryBean(Protocol protocol) {
        Assert.notNull((Object)((Object)protocol), (String)"'protocol' cannot be null");
        this.protocol = protocol;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setConnectionFactory(AbstractServerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setUdpAdapter(UnicastReceivingChannelAdapter udpAdapter) {
        this.udpAdapter = udpAdapter;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void start() {
        if (this.syslogAdapter != null) {
            this.syslogAdapter.start();
        }
    }

    public void stop() {
        if (this.syslogAdapter != null) {
            this.syslogAdapter.stop();
        }
    }

    public boolean isRunning() {
        if (this.syslogAdapter != null) {
            return this.syslogAdapter.isRunning();
        }
        return false;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        if (this.syslogAdapter != null) {
            this.syslogAdapter.stop(callback);
        } else {
            callback.run();
        }
    }

    public Class<?> getObjectType() {
        return this.syslogAdapter == null ? SyslogReceivingChannelAdapterSupport.class : ((Object)((Object)this.syslogAdapter)).getClass();
    }

    protected SyslogReceivingChannelAdapterSupport createInstance() {
        SyslogReceivingChannelAdapterSupport adapter;
        if (this.protocol == Protocol.tcp) {
            adapter = new TcpSyslogReceivingChannelAdapter();
            if (this.connectionFactory != null) {
                Assert.isNull((Object)this.port, (String)"Cannot specify both 'port' and 'connectionFactory'");
                ((TcpSyslogReceivingChannelAdapter)adapter).setConnectionFactory(this.connectionFactory);
            } else if (this.applicationEventPublisher != null) {
                ((TcpSyslogReceivingChannelAdapter)adapter).setApplicationEventPublisher(this.applicationEventPublisher);
            }
            Assert.isNull((Object)this.udpAdapter, (String)"Cannot specify 'udp-attributes' when the protocol is 'tcp'");
        } else if (this.protocol == Protocol.udp) {
            adapter = new UdpSyslogReceivingChannelAdapter();
            if (this.udpAdapter != null) {
                Assert.isNull((Object)this.port, (String)"Cannot specify both 'port' and 'udpAdapter'");
                ((UdpSyslogReceivingChannelAdapter)adapter).setUdpAdapter(this.udpAdapter);
            }
            Assert.isNull((Object)this.connectionFactory, (String)"Cannot specify 'connection-factory' unless the protocol is 'tcp'");
        } else {
            throw new IllegalStateException("Unsupported protocol: " + this.protocol.toString());
        }
        adapter.setAutoStartup(this.autoStartup);
        adapter.setPhase(this.phase);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.port, adapter::setPort).acceptIfNotNull((Object)this.outputChannel, arg_0 -> ((SyslogReceivingChannelAdapterSupport)adapter).setOutputChannel(arg_0)).acceptIfNotNull((Object)this.errorChannel, arg_0 -> ((SyslogReceivingChannelAdapterSupport)adapter).setErrorChannel(arg_0)).acceptIfNotNull((Object)this.sendTimeout, arg_0 -> ((SyslogReceivingChannelAdapterSupport)adapter).setSendTimeout(arg_0)).acceptIfNotNull((Object)this.converter, adapter::setConverter).acceptIfNotNull((Object)this.beanName, arg_0 -> ((SyslogReceivingChannelAdapterSupport)adapter).setBeanName(arg_0)).acceptIfNotNull((Object)this.getBeanFactory(), arg_0 -> ((SyslogReceivingChannelAdapterSupport)adapter).setBeanFactory(arg_0));
        adapter.afterPropertiesSet();
        this.syslogAdapter = adapter;
        return this.syslogAdapter;
    }

    public static enum Protocol {
        udp,
        tcp;

    }
}

