/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class UdpSyslogReceivingChannelAdapter
extends SyslogReceivingChannelAdapterSupport {
    private volatile UnicastReceivingChannelAdapter udpAdapter;
    private volatile boolean udpAdapterSet;

    public void setUdpAdapter(UnicastReceivingChannelAdapter udpAdpter) {
        this.udpAdapter = udpAdpter;
        this.udpAdapterSet = true;
    }

    public String getComponentType() {
        return "syslog:inbound-channel-adapter(udp)";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.udpAdapter == null) {
            this.udpAdapter = new UnicastReceivingChannelAdapter(this.getPort());
            this.udpAdapter.setBeanFactory(this.getBeanFactory());
        } else {
            this.logger.info((Object)"The 'UdpSyslogReceivingChannelAdapter' overrides an 'outputChannel' of the provided 'UnicastReceivingChannelAdapter' to support Syslog conversion for the incoming UDP packets");
        }
        this.udpAdapter.setOutputChannel((MessageChannel)new FixedSubscriberChannel(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                UdpSyslogReceivingChannelAdapter.this.convertAndSend(message);
            }
        }));
        if (!this.udpAdapterSet) {
            this.udpAdapter.afterPropertiesSet();
        }
    }

    protected void doStart() {
        super.doStart();
        this.udpAdapter.start();
    }

    protected void doStop() {
        super.doStop();
        this.udpAdapter.stop();
    }
}

