/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.messaging.MessagingException;

public class ByteStreamReadingMessageSource
extends AbstractMessageSource<byte[]> {
    private final BufferedInputStream stream;
    private int bytesPerMessage = 1024;
    private boolean shouldTruncate = true;

    public ByteStreamReadingMessageSource(InputStream stream) {
        this(stream, -1);
    }

    public ByteStreamReadingMessageSource(InputStream stream, int bufferSize) {
        this.stream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : (bufferSize > 0 ? new BufferedInputStream(stream, bufferSize) : new BufferedInputStream(stream));
    }

    public void setBytesPerMessage(int bytesPerMessage) {
        this.bytesPerMessage = bytesPerMessage;
    }

    public void setShouldTruncate(boolean shouldTruncate) {
        this.shouldTruncate = shouldTruncate;
    }

    public String getComponentType() {
        return "stream:stdin-channel-adapter(byte)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doReceive() {
        try {
            byte[] bytes;
            int bytesRead = 0;
            BufferedInputStream bufferedInputStream = this.stream;
            synchronized (bufferedInputStream) {
                if (this.stream.available() == 0) {
                    return null;
                }
                bytes = new byte[this.bytesPerMessage];
                bytesRead = this.stream.read(bytes, 0, bytes.length);
            }
            if (bytesRead <= 0) {
                return null;
            }
            if (!this.shouldTruncate) {
                return bytes;
            }
            byte[] result = new byte[bytesRead];
            System.arraycopy(bytes, 0, result, 0, result.length);
            return result;
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }
}

