/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp.outbound;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompExceptionEvent;
import org.springframework.integration.stomp.event.StompReceiptEvent;
import org.springframework.integration.stomp.support.StompHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.Assert;

public class StompMessageHandler
extends AbstractMessageHandler
implements IntegrationEvaluationContextAware,
ApplicationEventPublisherAware,
Lifecycle {
    private final StompSessionHandler sessionHandler = new IntegrationOutboundStompSessionHandler();
    private final StompSessionManager stompSessionManager;
    private volatile StompSession stompSession;
    private volatile boolean running;
    private volatile HeaderMapper<StompHeaders> headerMapper = new StompHeaderMapper();
    private Expression destinationExpression;
    private EvaluationContext evaluationContext;
    private ApplicationEventPublisher applicationEventPublisher;

    public StompMessageHandler(StompSessionManager stompSessionManager) {
        Assert.notNull((Object)stompSessionManager, (String)"'stompSessionManager' is required.");
        this.stompSessionManager = stompSessionManager;
    }

    public void setDestination(String destination) {
        Assert.hasText((String)destination, (String)"'destination' must not be empty.");
        this.destinationExpression = new ValueExpression((Object)destination);
    }

    public void setDestinationExpression(Expression destinationExpression) {
        Assert.notNull((Object)destinationExpression, (String)"'destinationExpression' must not be null.");
        this.destinationExpression = destinationExpression;
    }

    public void setHeaderMapper(HeaderMapper<StompHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"'headerMapper' must not be null.");
        this.headerMapper = headerMapper;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void handleMessageInternal(final Message<?> message) throws Exception {
        if (!this.isRunning()) {
            throw new MessageDeliveryException(message, "The StompMessageHandler [" + this.getComponentName() + "] hasn't been connected to StompSession. Check the state of [" + this.stompSessionManager + "]");
        }
        StompHeaders stompHeaders = new StompHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)stompHeaders);
        if (stompHeaders.getDestination() == null) {
            Assert.state((this.destinationExpression != null ? 1 : 0) != 0, (String)"One of 'destination' or 'destinationExpression' must be provided, if message header doesn't supply 'destination' STOMP header.");
            String destination = (String)this.destinationExpression.getValue(this.evaluationContext, message, String.class);
            stompHeaders.setDestination(destination);
        }
        final StompSession.Receiptable receiptable = this.stompSession.send(stompHeaders, message.getPayload());
        if (this.stompSessionManager.isAutoReceiptEnabled()) {
            final String destination = stompHeaders.getDestination();
            if (this.applicationEventPublisher != null) {
                receiptable.addReceiptTask(new Runnable(){

                    @Override
                    public void run() {
                        StompReceiptEvent event = new StompReceiptEvent((Object)StompMessageHandler.this, destination, receiptable.getReceiptId(), StompCommand.SEND, false);
                        event.setMessage(message);
                        StompMessageHandler.this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                    }
                });
            }
            receiptable.addReceiptLostTask(new Runnable(){

                @Override
                public void run() {
                    if (StompMessageHandler.this.applicationEventPublisher != null) {
                        StompReceiptEvent event = new StompReceiptEvent((Object)StompMessageHandler.this, destination, receiptable.getReceiptId(), StompCommand.SEND, true);
                        event.setMessage(message);
                        StompMessageHandler.this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                    } else {
                        StompMessageHandler.this.logger.error((Object)("The receipt [" + receiptable.getReceiptId() + "] is lost for [" + message + "] on destination [" + destination + "]"));
                    }
                }
            });
        }
    }

    public void start() {
        this.stompSessionManager.connect(this.sessionHandler);
    }

    public void stop() {
        this.stompSessionManager.disconnect(this.sessionHandler);
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private class IntegrationOutboundStompSessionHandler
    extends StompSessionHandlerAdapter {
        private IntegrationOutboundStompSessionHandler() {
        }

        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            StompMessageHandler.this.stompSession = session;
            StompMessageHandler.this.running = true;
        }

        public void handleFrame(StompHeaders headers, Object payload) {
            Object thePayload = payload;
            if (thePayload == null) {
                thePayload = headers.getFirst("message");
            }
            if (thePayload != null) {
                Message failedMessage = StompMessageHandler.this.getMessageBuilderFactory().withPayload(thePayload).copyHeaders(StompMessageHandler.this.headerMapper.toHeaders((Object)headers)).build();
                MessageDeliveryException exception = new MessageDeliveryException(failedMessage, "STOMP frame handling error.");
                StompMessageHandler.this.logger.error((Object)"STOMP frame handling error.", (Throwable)exception);
                if (StompMessageHandler.this.applicationEventPublisher != null) {
                    StompMessageHandler.this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompExceptionEvent((Object)StompMessageHandler.this, (Throwable)exception));
                }
            }
        }
    }
}

