/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompExceptionEvent;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class AbstractStompSessionManager
implements StompSessionManager,
ApplicationEventPublisherAware,
InitializingBean,
DisposableBean,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CompositeStompSessionHandler compositeStompSessionHandler = new CompositeStompSessionHandler();
    protected final StompClientSupport stompClient;
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile StompHeaders connectHeaders;
    private volatile ListenableFuture<StompSession> stompSessionListenableFuture;
    private volatile boolean autoReceipt;
    private volatile boolean connected;
    private String name;

    public AbstractStompSessionManager(StompClientSupport stompClient) {
        Assert.notNull((Object)stompClient, (String)"'stompClient' is required.");
        this.stompClient = stompClient;
    }

    public void setConnectHeaders(StompHeaders connectHeaders) {
        this.connectHeaders = connectHeaders;
    }

    public void setAutoReceipt(boolean autoReceipt) {
        this.autoReceipt = autoReceipt;
    }

    @Override
    public boolean isAutoReceiptEnabled() {
        return this.autoReceipt;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        this.stompSessionListenableFuture = this.doConnect((StompSessionHandler)this.compositeStompSessionHandler);
        this.stompSessionListenableFuture.addCallback((ListenableFutureCallback)new ListenableFutureCallback<StompSession>(){

            public void onFailure(Throwable e) {
                AbstractStompSessionManager.this.logger.error((Object)"STOMP connect error.", e);
                if (AbstractStompSessionManager.this.applicationEventPublisher != null) {
                    AbstractStompSessionManager.this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompExceptionEvent(AbstractStompSessionManager.this, e));
                }
            }

            public void onSuccess(StompSession stompSession) {
                stompSession.setAutoReceipt(AbstractStompSessionManager.this.autoReceipt);
                AbstractStompSessionManager.this.connected = true;
            }
        });
    }

    public void destroy() throws Exception {
        this.stompSessionListenableFuture.addCallback((ListenableFutureCallback)new ListenableFutureCallback<StompSession>(){

            public void onFailure(Throwable ex) {
                AbstractStompSessionManager.this.connected = false;
            }

            public void onSuccess(StompSession session) {
                session.disconnect();
                AbstractStompSessionManager.this.connected = false;
            }
        });
    }

    @Override
    public void connect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.addHandler(handler);
    }

    @Override
    public void disconnect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.removeHandler(handler);
    }

    protected StompHeaders getConnectHeaders() {
        return this.connectHeaders;
    }

    public String toString() {
        return "StompSessionManager{connected=" + this.connected + ", name='" + this.name + '\'' + '}';
    }

    protected abstract ListenableFuture<StompSession> doConnect(StompSessionHandler var1);

    private static class CompositeStompSessionHandler
    extends StompSessionHandlerAdapter {
        private final List<StompSessionHandler> delegates = new ArrayList<StompSessionHandler>();
        private volatile StompSession session;
        private volatile StompHeaders connectedHeaders;

        private CompositeStompSessionHandler() {
        }

        void addHandler(StompSessionHandler delegate) {
            if (this.session != null) {
                delegate.afterConnected(this.session, this.connectedHeaders);
            }
            this.delegates.add(delegate);
        }

        void removeHandler(StompSessionHandler delegate) {
            this.delegates.remove(delegate);
        }

        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            this.session = session;
            this.connectedHeaders = connectedHeaders;
            for (StompSessionHandler delegate : this.delegates) {
                delegate.afterConnected(session, connectedHeaders);
            }
        }

        public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            for (StompSessionHandler delegate : this.delegates) {
                delegate.handleException(session, command, headers, payload, exception);
            }
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            for (StompSessionHandler delegate : this.delegates) {
                delegate.handleTransportError(session, exception);
            }
        }

        public void handleFrame(StompHeaders headers, Object payload) {
            for (StompSessionHandler delegate : this.delegates) {
                delegate.handleFrame(headers, payload);
            }
        }
    }
}

