/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.dsl;

import java.io.File;
import java.util.Comparator;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.dsl.RemoteFileInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.smb.filters.SmbPersistentAcceptOnceFileListFilter;
import org.springframework.integration.smb.filters.SmbRegexPatternFileListFilter;
import org.springframework.integration.smb.filters.SmbSimplePatternFileListFilter;
import org.springframework.integration.smb.inbound.SmbInboundFileSynchronizer;
import org.springframework.integration.smb.inbound.SmbInboundFileSynchronizingMessageSource;

public class SmbInboundChannelAdapterSpec
extends RemoteFileInboundChannelAdapterSpec<SmbFile, SmbInboundChannelAdapterSpec, SmbInboundFileSynchronizingMessageSource> {
    protected SmbInboundChannelAdapterSpec(SessionFactory<SmbFile> sessionFactory, @Nullable Comparator<File> comparator) {
        super((AbstractInboundFileSynchronizer)new SmbInboundFileSynchronizer(sessionFactory));
        this.target = new SmbInboundFileSynchronizingMessageSource((AbstractInboundFileSynchronizer<SmbFile>)this.synchronizer, comparator);
    }

    public SmbInboundChannelAdapterSpec patternFilter(String pattern) {
        return (SmbInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SmbFile>)new SmbSimplePatternFileListFilter(pattern)));
    }

    public SmbInboundChannelAdapterSpec regexFilter(String regex) {
        return (SmbInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SmbFile>)new SmbRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<SmbFile> composeFilters(FileListFilter<SmbFile> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new SmbPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "smbMessageSource")});
        return compositeFileListFilter;
    }
}

