/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;

public class SmbRemoteFileTemplate
extends RemoteFileTemplate<SmbFile> {
    protected static final List<Integer> NOT_DIRTY_STATUSES = List.of(-1073741816, -1073741807, -1073741809, -1073741635, -1073741638, -1073741565, -1073741275, -1073741771, -1073741773, -1073741772, -1073741767, -1073741766, -1073741765, -1073741535);

    public SmbRemoteFileTemplate(SessionFactory<SmbFile> sessionFactory) {
        super(sessionFactory);
    }

    protected boolean shouldMarkSessionAsDirty(Exception ex) {
        SmbException smbException = SmbRemoteFileTemplate.findSmbException(ex);
        if (smbException != null) {
            return this.isStatusDirty(smbException.getNtStatus());
        }
        return super.shouldMarkSessionAsDirty(ex);
    }

    protected boolean isStatusDirty(int status) {
        return !NOT_DIRTY_STATUSES.contains(status);
    }

    private static @Nullable SmbException findSmbException(@Nullable Throwable ex) {
        if (ex == null || ex instanceof SmbException) {
            return (SmbException)ex;
        }
        return SmbRemoteFileTemplate.findSmbException(ex.getCause());
    }
}

