/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.smb.session.SmbFileInfo;
import org.springframework.integration.smb.session.SmbRemoteFileTemplate;

public class SmbOutboundGateway
extends AbstractRemoteFileOutboundGateway<SmbFile> {
    public SmbOutboundGateway(SessionFactory<SmbFile> sessionFactory, MessageSessionCallback<SmbFile, ?> messageSessionCallback) {
        this((RemoteFileTemplate<SmbFile>)new SmbRemoteFileTemplate(sessionFactory), messageSessionCallback);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SmbOutboundGateway(RemoteFileTemplate<SmbFile> remoteFileTemplate, MessageSessionCallback<SmbFile, ?> messageSessionCallback) {
        super(remoteFileTemplate, messageSessionCallback);
    }

    public SmbOutboundGateway(SessionFactory<SmbFile> sessionFactory, String command, @Nullable String expression) {
        this(new SmbRemoteFileTemplate(sessionFactory), command, expression);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public SmbOutboundGateway(RemoteFileTemplate<SmbFile> remoteFileTemplate, String command, @Nullable String expression) {
        super(remoteFileTemplate, command, expression);
    }

    public SmbOutboundGateway(SessionFactory<SmbFile> sessionFactory, String command) {
        this(sessionFactory, command, null);
    }

    public SmbOutboundGateway(RemoteFileTemplate<SmbFile> remoteFileTemplate, String command) {
        this(remoteFileTemplate, command, null);
    }

    public String getComponentType() {
        return "smb:outbound-gateway";
    }

    protected boolean isDirectory(SmbFile file) {
        try {
            return file.isDirectory();
        }
        catch (SmbException se) {
            this.logger.error((Throwable)se, (CharSequence)"Unable to determine if this SmbFile represents a directory");
            return false;
        }
    }

    protected boolean isLink(SmbFile file) {
        return false;
    }

    protected String getFilename(AbstractFileInfo<SmbFile> file) {
        return this.getFilename((SmbFile)file.getFileInfo());
    }

    protected String getFilename(SmbFile file) {
        String name = file.getName();
        return name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
    }

    protected long getModified(SmbFile file) {
        return file.getLastModified();
    }

    protected List<AbstractFileInfo<SmbFile>> asFileInfoList(Collection<SmbFile> files) {
        ArrayList<AbstractFileInfo<SmbFile>> canonicalFiles = new ArrayList<AbstractFileInfo<SmbFile>>();
        for (SmbFile file : files) {
            canonicalFiles.add(new SmbFileInfo(file));
        }
        return canonicalFiles;
    }

    protected SmbFile enhanceNameWithSubDirectory(SmbFile file, String directory) {
        return file;
    }

    protected String getFullFileName(String remoteDirectory, SmbFile smbFile) {
        return smbFile.getLocator().getURLPath().substring(1).replaceFirst(smbFile.getShare() + "/?", "");
    }
}

