/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.dsl;

import java.util.Comparator;
import jcifs.smb.SmbFile;
import org.springframework.integration.file.dsl.RemoteFileStreamingInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.smb.filters.SmbPersistentAcceptOnceFileListFilter;
import org.springframework.integration.smb.filters.SmbRegexPatternFileListFilter;
import org.springframework.integration.smb.filters.SmbSimplePatternFileListFilter;
import org.springframework.integration.smb.inbound.SmbStreamingMessageSource;
import org.springframework.lang.Nullable;

public class SmbStreamingInboundChannelAdapterSpec
extends RemoteFileStreamingInboundChannelAdapterSpec<SmbFile, SmbStreamingInboundChannelAdapterSpec, SmbStreamingMessageSource> {
    protected SmbStreamingInboundChannelAdapterSpec(RemoteFileTemplate<SmbFile> remoteFileTemplate, @Nullable Comparator<SmbFile> comparator) {
        this.target = new SmbStreamingMessageSource(remoteFileTemplate, comparator);
    }

    public SmbStreamingInboundChannelAdapterSpec patternFilter(String pattern) {
        return (SmbStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SmbFile>)new SmbSimplePatternFileListFilter(pattern)));
    }

    public SmbStreamingInboundChannelAdapterSpec regexFilter(String regex) {
        return (SmbStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SmbFile>)new SmbRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<SmbFile> composeFilters(FileListFilter<SmbFile> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new SmbPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "smbStreamingMessageSource")});
        return compositeFileListFilter;
    }
}

