/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.IOException;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.smb.SmbFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.smb.session.SmbConfig;
import org.springframework.integration.smb.session.SmbSession;
import org.springframework.integration.smb.session.SmbShare;
import org.springframework.util.Assert;

public class SmbSessionFactory
extends SmbConfig
implements SessionFactory<SmbFile> {
    private static final Log logger = LogFactory.getLog(SmbSessionFactory.class);
    private CIFSContext context = null;

    public SmbSessionFactory() {
        logger.debug((Object)("New " + this.getClass().getName() + " created."));
    }

    public SmbSessionFactory(CIFSContext _context) {
        Assert.notNull((Object)_context, (String)"_context can't be null");
        this.context = _context;
        logger.debug((Object)("New " + this.getClass().getName() + " created with CIFSContext."));
    }

    public final SmbSession getSession() {
        try {
            return this.createSession();
        }
        catch (Exception _ex) {
            throw new IllegalStateException("Failed to create session.", _ex);
        }
    }

    protected SmbSession createSession() throws IOException {
        SmbShare smbShare;
        if (this.context != null) {
            smbShare = new SmbShare((SmbConfig)this, this.context);
        } else {
            Properties props = new Properties();
            props.setProperty("jcifs.smb.client.minVersion", this.getSmbMinVersion().name());
            props.setProperty("jcifs.smb.client.maxVersion", this.getSmbMaxVersion().name());
            smbShare = new SmbShare((SmbConfig)this, props);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SMB share init: %s/%s", this.getHostPort(), this.getShareAndDir()));
        }
        smbShare.init();
        logger.debug((Object)"SMB share initialized.");
        return new SmbSession(smbShare);
    }
}

