/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.IOException;
import java.util.Arrays;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class SmbFileInfo
extends AbstractFileInfo<SmbFile> {
    private static final Log logger = LogFactory.getLog(SmbFileInfo.class);
    private final SmbFile smbFile;

    public SmbFileInfo(SmbFile smbFile) {
        Assert.notNull((Object)smbFile, (String)"SmbFile must not be null");
        this.smbFile = smbFile;
    }

    public boolean isDirectory() {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException se) {
            logger.error((Object)"Unable to determine if this SmbFile represents a directory", (Throwable)se);
            return false;
        }
    }

    public boolean isLink() {
        return false;
    }

    public long getSize() {
        try {
            return this.smbFile.length();
        }
        catch (SmbException se) {
            logger.error((Object)"Unable to determine file size", (Throwable)se);
            return 0L;
        }
    }

    public long getModified() {
        return this.smbFile.getLastModified();
    }

    public String getFilename() {
        return this.smbFile.getName();
    }

    public String getPermissions() {
        Object[] aceArray = null;
        try {
            aceArray = this.smbFile.getSecurity(true);
        }
        catch (IOException se) {
            logger.error((Object)"Unable to determine security descriptor information for this SmbFile", (Throwable)se);
        }
        return aceArray == null ? null : Arrays.toString(aceArray);
    }

    public SmbFile getFileInfo() {
        return this.smbFile;
    }
}

