/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.inbound;

import org.apache.sshd.sftp.client.SftpClient;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;

public class SftpInboundFileSynchronizer
extends AbstractInboundFileSynchronizer<SftpClient.DirEntry> {
    public SftpInboundFileSynchronizer(SessionFactory<SftpClient.DirEntry> sessionFactory) {
        super(sessionFactory);
        this.doSetFilter((FileListFilter)new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpMessageSource"));
    }

    protected boolean isFile(SftpClient.DirEntry file) {
        return file.getAttributes().isRegularFile();
    }

    protected String getFilename(SftpClient.DirEntry file) {
        return file.getFilename();
    }

    protected long getModified(SftpClient.DirEntry file) {
        return file.getAttributes().getModifyTime().toMillis();
    }

    protected String protocol() {
        return "sftp";
    }
}

