/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.security.channel.ChannelAccessPolicy;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.DefaultChannelAccessPolicy;
import org.springframework.integration.security.channel.SecuredChannel;
import org.springframework.integration.security.config.ChannelSecurityInterceptorBeanPostProcessor;

public class SecurityIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final String CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME = ChannelSecurityInterceptorBeanPostProcessor.class.getName();

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ManagedMap securityInterceptors = new ManagedMap();
        HashMap<String, Map<Pattern, ChannelAccessPolicy>> policies = new HashMap<String, Map<Pattern, ChannelAccessPolicy>>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            Object beanSource;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (ChannelSecurityInterceptor.class.getName().equals(beanDefinition.getBeanClassName())) {
                this.collectPatternsFromInterceptor((Map<String, Set<String>>)securityInterceptors, beanName, beanDefinition);
                continue;
            }
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !((beanSource = beanDefinition.getSource()) instanceof MethodMetadata)) continue;
            this.collectInterceptorsAndPoliciesBySecuredChannel((Map<String, Set<String>>)securityInterceptors, policies, beanName, (MethodMetadata)beanSource);
        }
        if (!securityInterceptors.isEmpty()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ChannelSecurityInterceptorBeanPostProcessor.class).addConstructorArgValue((Object)securityInterceptors);
            if (!policies.isEmpty()) {
                builder.addConstructorArgValue(policies);
            }
            registry.registerBeanDefinition(CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private void collectPatternsFromInterceptor(Map<String, Set<String>> securityInterceptors, String beanName, BeanDefinition beanDefinition) {
        ConstructorArgumentValues.ValueHolder patternMappingsValueHolder;
        BeanDefinition metadataSource;
        ConstructorArgumentValues.ValueHolder metadataSourceValueHolder = beanDefinition.getConstructorArgumentValues().getIndexedArgumentValue(0, BeanDefinition.class);
        if (metadataSourceValueHolder != null && (metadataSource = (BeanDefinition)metadataSourceValueHolder.getValue()) != null && (patternMappingsValueHolder = metadataSource.getConstructorArgumentValues().getIndexedArgumentValue(0, Map.class)) != null) {
            Map patternsToAdd = (Map)patternMappingsValueHolder.getValue();
            Object patterns = new ManagedSet();
            if (!securityInterceptors.containsKey(beanName)) {
                securityInterceptors.put(beanName, (Set<String>)patterns);
            } else {
                patterns = securityInterceptors.get(beanName);
            }
            if (patternsToAdd != null) {
                patterns.addAll(patternsToAdd.keySet());
            }
        }
    }

    private void collectInterceptorsAndPoliciesBySecuredChannel(Map<String, Set<String>> securityInterceptors, Map<String, Map<Pattern, ChannelAccessPolicy>> policies, String beanName, MethodMetadata beanMethod) {
        Map securedAttributes = beanMethod.getAnnotationAttributes(SecuredChannel.class.getName());
        if (securedAttributes != null) {
            String[] interceptors = (String[])securedAttributes.get("interceptor");
            String[] sendAccess = (String[])securedAttributes.get("sendAccess");
            String[] receiveAccess = (String[])securedAttributes.get("receiveAccess");
            DefaultChannelAccessPolicy accessPolicy = new DefaultChannelAccessPolicy(sendAccess, receiveAccess);
            for (String interceptor : interceptors) {
                Object patterns = new ManagedSet();
                if (!securityInterceptors.containsKey(interceptor)) {
                    securityInterceptors.put(interceptor, (Set<String>)patterns);
                } else {
                    patterns = securityInterceptors.get(interceptor);
                }
                patterns.add(beanName);
                Map<Object, Object> mapping = new HashMap();
                if (!policies.containsKey(interceptor)) {
                    policies.put(interceptor, mapping);
                } else {
                    mapping = policies.get(interceptor);
                }
                mapping.put(Pattern.compile(beanName), accessPolicy);
            }
        }
    }
}

