/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.channel;

import org.springframework.aop.support.AopUtils;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.interceptor.ThreadStatePropagationChannelInterceptor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextPropagationChannelInterceptor
extends ThreadStatePropagationChannelInterceptor<Authentication> {
    private static final SecurityContext EMPTY_CONTEXT = SecurityContextHolder.createEmptyContext();
    private static final ThreadLocal<SecurityContext> ORIGINAL_CONTEXT = new ThreadLocal();

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        this.cleanup();
    }

    protected Authentication obtainPropagatingContext(Message<?> message, MessageChannel channel) {
        if (!DirectChannel.class.isAssignableFrom(AopUtils.getTargetClass((Object)channel))) {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    protected void populatePropagatedContext(Authentication authentication, Message<?> message, MessageChannel channel) {
        if (authentication != null) {
            SecurityContext currentContext = SecurityContextHolder.getContext();
            ORIGINAL_CONTEXT.set(currentContext);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authentication);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
    }

    private void cleanup() {
        SecurityContext originalContext = ORIGINAL_CONTEXT.get();
        try {
            if (originalContext == null || EMPTY_CONTEXT.equals(originalContext)) {
                SecurityContextHolder.clearContext();
                ORIGINAL_CONTEXT.remove();
            } else {
                SecurityContextHolder.setContext((SecurityContext)originalContext);
            }
        }
        catch (Throwable t) {
            SecurityContextHolder.clearContext();
        }
    }
}

