/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public class RefreshableResourceScriptSource
implements ScriptSource {
    private final long refreshDelay;
    private final ResourceScriptSource source;
    private final AtomicLong lastModifiedChecked = new AtomicLong(System.currentTimeMillis());
    private volatile String script;

    public RefreshableResourceScriptSource(Resource resource, long refreshDelay) {
        this.refreshDelay = refreshDelay;
        this.source = new ResourceScriptSource(resource);
        try {
            this.script = this.source.getScriptAsString();
        }
        catch (IOException e) {
            this.lastModifiedChecked.set(0L);
        }
    }

    public String getScriptAsString() throws IOException {
        if (this.script == null || this.isModified()) {
            this.lastModifiedChecked.set(System.currentTimeMillis());
            this.script = this.source.getScriptAsString();
        }
        return this.script;
    }

    public @Nullable String suggestedClassName() {
        return this.source.getResource().getFilename();
    }

    public boolean isModified() {
        return this.refreshDelay >= 0L && System.currentTimeMillis() - this.lastModifiedChecked.get() > this.refreshDelay && this.source.isModified();
    }

    public String toString() {
        return this.source.toString();
    }
}

