/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.config.jsr223;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.scripting.config.AbstractScriptParser;
import org.springframework.integration.scripting.jsr223.ScriptExecutorFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ScriptParser
extends AbstractScriptParser {
    private static final String LANGUAGE_ATTRIBUTE = "lang";

    @Override
    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.scripting.jsr223.ScriptExecutingMessageProcessor";
    }

    @Override
    protected String getScriptSourceClassName() {
        return null;
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String language = element.getAttribute(LANGUAGE_ATTRIBUTE);
        String scriptLocation = element.getAttribute("location");
        if (!StringUtils.hasText((String)language)) {
            if (!StringUtils.hasText((String)scriptLocation)) {
                parserContext.getReaderContext().error("An inline script requires the 'lang' attribute.", (Object)element);
                return;
            }
            language = this.getLanguageFromFileExtension(scriptLocation, parserContext, element);
            if (language == null) {
                parserContext.getReaderContext().error("Unable to determine language for script '" + scriptLocation + "'", (Object)element);
                return;
            }
        }
        builder.addConstructorArgValue((Object)ScriptExecutorFactory.getScriptExecutor(language));
    }

    private String getLanguageFromFileExtension(String scriptLocation, ParserContext parserContext, Element element) {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine engine = null;
        int index = scriptLocation.lastIndexOf(".") + 1;
        if (index < 1) {
            return null;
        }
        String extension = scriptLocation.substring(index);
        engine = engineManager.getEngineByExtension(extension);
        if (engine == null) {
            parserContext.getReaderContext().error("No suitable scripting engine found for extension '" + extension + "'", (Object)element);
        }
        return engine.getFactory().getLanguageName();
    }
}

