/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import io.rsocket.core.RSocketServer;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.integration.rsocket.AbstractRSocketConnector;
import org.springframework.integration.rsocket.ServerRSocketMessageHandler;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServer;

public class ServerRSocketConnector
extends AbstractRSocketConnector
implements ApplicationEventPublisherAware {
    private final @Nullable ServerTransport<CloseableChannel> serverTransport;
    private Consumer<RSocketServer> serverConfigurer;
    private Mono<CloseableChannel> serverMono;

    public ServerRSocketConnector(ServerRSocketMessageHandler serverRSocketMessageHandler) {
        super(serverRSocketMessageHandler);
        this.serverConfigurer = rsocketServer -> {};
        this.serverTransport = null;
    }

    public ServerRSocketConnector(String bindAddress, int port) {
        this((ServerTransport<CloseableChannel>)TcpServerTransport.create((String)bindAddress, (int)port));
    }

    public ServerRSocketConnector(HttpServer server) {
        this((ServerTransport<CloseableChannel>)WebsocketServerTransport.create((HttpServer)server));
    }

    public ServerRSocketConnector(ServerTransport<CloseableChannel> serverTransport) {
        super(new ServerRSocketMessageHandler());
        this.serverConfigurer = rsocketServer -> {};
        Assert.notNull(serverTransport, (String)"'serverTransport' must not be null");
        this.serverTransport = serverTransport;
    }

    private ServerRSocketMessageHandler serverRSocketMessageHandler() {
        return (ServerRSocketMessageHandler)this.rSocketMessageHandler;
    }

    public void setServerConfigurer(Consumer<RSocketServer> serverConfigurer) {
        this.serverConfigurer = serverConfigurer;
    }

    public void setClientRSocketKeyStrategy(BiFunction<Map<String, Object>, DataBuffer, Object> clientRSocketKeyStrategy) {
        if (this.serverTransport != null) {
            this.serverRSocketMessageHandler().setClientRSocketKeyStrategy(clientRSocketKeyStrategy);
        }
    }

    @Override
    public void setDataMimeType(@Nullable MimeType dataMimeType) {
        if (this.serverTransport != null) {
            super.setDataMimeType(dataMimeType);
        }
    }

    @Override
    public void setMetadataMimeType(MimeType metadataMimeType) {
        if (this.serverTransport != null) {
            super.setMetadataMimeType(metadataMimeType);
        }
    }

    @Override
    public void setRSocketStrategies(RSocketStrategies rsocketStrategies) {
        if (this.serverTransport != null) {
            super.setRSocketStrategies(rsocketStrategies);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.serverTransport != null) {
            super.setApplicationContext(applicationContext);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        if (this.serverTransport != null) {
            this.serverRSocketMessageHandler().setApplicationEventPublisher(applicationEventPublisher);
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.serverTransport != null) {
            super.afterPropertiesSet();
            RSocketServer rsocketServer = RSocketServer.create();
            this.serverConfigurer.accept(rsocketServer);
            this.serverMono = rsocketServer.acceptor(this.serverRSocketMessageHandler().responder()).bind(this.serverTransport).cache();
        }
    }

    public Map<Object, RSocketRequester> getClientRSocketRequesters() {
        return this.serverRSocketMessageHandler().getClientRSocketRequesters();
    }

    public @Nullable RSocketRequester getClientRSocketRequester(Object key) {
        return this.serverRSocketMessageHandler().getClientRSocketRequester(key);
    }

    public Mono<Integer> getBoundPort() {
        if (this.serverTransport != null) {
            return this.serverMono.map(server -> server.address().getPort());
        }
        return Mono.empty();
    }

    @Override
    protected void doStart() {
        if (this.serverTransport != null) {
            this.serverMono.subscribe();
        }
    }

    public void destroy() {
        if (this.serverTransport != null) {
            this.serverMono.doOnNext(Disposable::dispose).subscribe();
        }
    }

    @Override
    public void afterSingletonsInstantiated() {
        super.afterSingletonsInstantiated();
        this.serverRSocketMessageHandler().registerHandleConnectionSetupMethod();
    }
}

