/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RedisQueueOutboundChannelAdapter
extends AbstractMessageHandler {
    private final RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    private final RedisTemplate<String, Object> template;
    private final Expression queueNameExpression;
    private volatile EvaluationContext evaluationContext;
    private volatile boolean extractPayload = true;
    private volatile RedisSerializer<?> serializer = new JdkSerializationRedisSerializer();
    private volatile boolean serializerExplicitlySet;
    private volatile boolean leftPush = true;

    public RedisQueueOutboundChannelAdapter(String queueName, RedisConnectionFactory connectionFactory) {
        this((Expression)new LiteralExpression(queueName), connectionFactory);
    }

    public RedisQueueOutboundChannelAdapter(Expression queueNameExpression, RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)queueNameExpression, (String)"'queueNameExpression' is required");
        Assert.hasText((String)queueNameExpression.getExpressionString(), (String)"'queueNameExpression.getExpressionString()' is required");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.queueNameExpression = queueNameExpression;
        this.template = new RedisTemplate();
        this.template.setConnectionFactory(connectionFactory);
        this.template.setEnableDefaultSerializer(false);
        this.template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.template.afterPropertiesSet();
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
        this.serializerExplicitlySet = true;
    }

    public void setLeftPush(boolean leftPush) {
        this.leftPush = leftPush;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public String getComponentType() {
        return "redis:queue-outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object value = message;
        if (this.extractPayload) {
            value = message.getPayload();
        }
        if (!(value instanceof byte[])) {
            value = value instanceof String && !this.serializerExplicitlySet ? (Object)this.stringSerializer.serialize((Object)((String)value)) : (Object)this.serializer.serialize(value);
        }
        String queueName = (String)this.queueNameExpression.getValue(this.evaluationContext, message, String.class);
        if (this.leftPush) {
            this.template.boundListOps((Object)queueName).leftPush(value);
        } else {
            this.template.boundListOps((Object)queueName).rightPush(value);
        }
    }
}

