/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.metadata;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.collections.RedisProperties;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public class RedisMetadataStore
implements ConcurrentMetadataStore {
    public static final String KEY = "MetaData";
    private final RedisProperties properties;

    public RedisMetadataStore(RedisProperties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null.");
        this.properties = properties;
    }

    public RedisMetadataStore(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, KEY);
    }

    public RedisMetadataStore(RedisConnectionFactory connectionFactory, String key) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null.");
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        StringRedisTemplate redisTemplate = new StringRedisTemplate(connectionFactory);
        BoundHashOperations hashOperations = redisTemplate.boundHashOps((Object)key);
        this.properties = new RedisProperties(hashOperations);
    }

    public RedisMetadataStore(RedisOperations<String, ?> operations) {
        this(operations, KEY);
    }

    public RedisMetadataStore(RedisOperations<String, ?> operations, String key) {
        Assert.notNull(operations, (String)"'operations' must not be null.");
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        BoundHashOperations hashOperations = operations.boundHashOps((Object)key);
        this.properties = new RedisProperties(hashOperations);
    }

    public void put(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        this.properties.put((Object)key, (Object)value);
    }

    public String get(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Object value = this.properties.get((Object)key);
        if (value != null) {
            Assert.isInstanceOf(String.class, (Object)value, (String)"Invalid type in the store");
        }
        return (String)value;
    }

    public String remove(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Object removed = this.properties.remove((Object)key);
        if (removed != null) {
            Assert.isInstanceOf(String.class, (Object)removed, (String)"The removed value was an invalid type");
        }
        return (String)removed;
    }

    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        Object oldValue = this.properties.putIfAbsent((Object)key, (Object)value);
        if (oldValue != null) {
            Assert.isInstanceOf(String.class, (Object)oldValue, (String)"Invalid type in the store");
        }
        return (String)oldValue;
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
        Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
        return this.properties.replace((Object)key, (Object)oldValue, (Object)newValue);
    }
}

