/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.data.redis.core.RedisOperations;

public final class RedisUtils {
    private static final String SECTION = "server";
    private static final String VERSION_PROPERTY = "redis_version";
    private static final Map<RedisOperations<?, ?>, Boolean> unlinkAvailable = new LinkedHashMap<RedisOperations<?, ?>, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<RedisOperations<?, ?>, Boolean> eldest) {
            return this.size() > 100;
        }
    };

    public static boolean isUnlinkAvailable(RedisOperations<?, ?> redisOperations) {
        return unlinkAvailable.computeIfAbsent(redisOperations, key -> {
            Properties info = (Properties)redisOperations.execute(connection -> connection.serverCommands().info(SECTION));
            if (info != null) {
                int majorVersion = Integer.parseInt(info.getProperty(VERSION_PROPERTY).split("\\.")[0]);
                return majorVersion >= 4;
            }
            throw new IllegalStateException("The INFO command cannot be used in pipeline/transaction.");
        });
    }

    private RedisUtils() {
    }
}

