/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.store;

import java.util.Collection;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.redis.util.RedisUtils;
import org.springframework.integration.store.AbstractKeyValueMessageStore;
import org.springframework.util.Assert;

public class RedisMessageStore
extends AbstractKeyValueMessageStore
implements BeanClassLoaderAware {
    private final RedisTemplate<Object, Object> redisTemplate = new RedisTemplate();
    private boolean valueSerializerSet;

    public RedisMessageStore(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, "");
    }

    public RedisMessageStore(RedisConnectionFactory connectionFactory, String prefix) {
        super(prefix);
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        this.redisTemplate.afterPropertiesSet();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.valueSerializerSet) {
            this.redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer(classLoader));
        }
    }

    public void setValueSerializer(RedisSerializer<?> valueSerializer) {
        Assert.notNull(valueSerializer, (String)"'valueSerializer' must not be null");
        this.redisTemplate.setValueSerializer(valueSerializer);
        this.valueSerializerSet = true;
    }

    protected Object doRetrieve(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        BoundValueOperations ops = this.redisTemplate.boundValueOps(id);
        return ops.get();
    }

    protected void doStore(Object id, Object objectToStore) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)objectToStore, (String)"'objectToStore' must not be null");
        BoundValueOperations ops = this.redisTemplate.boundValueOps(id);
        try {
            ops.set(objectToStore);
        }
        catch (SerializationException e) {
            this.rethrowAsIllegalArgumentException(e);
        }
    }

    protected void doStoreIfAbsent(Object id, Object objectToStore) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)objectToStore, (String)"'objectToStore' must not be null");
        BoundValueOperations ops = this.redisTemplate.boundValueOps(id);
        try {
            Boolean present = ops.setIfAbsent(objectToStore);
            if (present != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The message: [" + present + "] is already present in the store. The [" + objectToStore + "] is ignored."));
            }
        }
        catch (SerializationException e) {
            this.rethrowAsIllegalArgumentException(e);
        }
    }

    protected Object doRemove(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Object removedObject = this.doRetrieve(id);
        if (removedObject != null) {
            if (RedisUtils.isUnlinkAvailable(this.redisTemplate)) {
                this.redisTemplate.unlink(id);
            } else {
                this.redisTemplate.delete(id);
            }
        }
        return removedObject;
    }

    protected void doRemoveAll(Collection<Object> ids) {
        if (RedisUtils.isUnlinkAvailable(this.redisTemplate)) {
            this.redisTemplate.unlink(ids);
        } else {
            this.redisTemplate.delete(ids);
        }
    }

    protected Collection<?> doListKeys(String keyPattern) {
        Assert.hasText((String)keyPattern, (String)"'keyPattern' must not be empty");
        return this.redisTemplate.keys((Object)keyPattern);
    }

    private void rethrowAsIllegalArgumentException(SerializationException e) {
        throw new IllegalArgumentException("If relying on the default RedisSerializer (JdkSerializationRedisSerializer) the Object must be Serializable. Either make it Serializable or provide your own implementation of RedisSerializer via 'setValueSerializer(..)'", e);
    }
}

