/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.store;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.redis.store.RedisChannelMessageStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RedisChannelPriorityMessageStore
extends RedisChannelMessageStore
implements PriorityCapableChannelMessageStore {
    private final Comparator<String> keysComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    };

    public RedisChannelPriorityMessageStore(RedisConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public boolean isPriorityEnabled() {
        return true;
    }

    @Override
    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        Assert.isInstanceOf(String.class, (Object)groupId);
        List<String> list = this.sortedKeys((String)groupId);
        int count = 0;
        for (String key : list) {
            count = (int)((long)count + this.getRedisTemplate().boundListOps((Object)key).size());
        }
        return count;
    }

    @Override
    public MessageGroup getMessageGroup(Object groupId) {
        Assert.isInstanceOf(String.class, (Object)groupId);
        LinkedList allMessages = new LinkedList();
        List<String> list = this.sortedKeys((String)groupId);
        for (String key : list) {
            List messages = this.getRedisTemplate().boundListOps((Object)key).range(0L, -1L);
            allMessages.addAll(messages);
        }
        return this.getMessageGroupFactory().create(allMessages, groupId);
    }

    @Override
    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.isInstanceOf(String.class, (Object)groupId);
        String key = (String)groupId;
        Integer priority = new IntegrationMessageHeaderAccessor(message).getPriority();
        if (priority != null && priority < 10 && priority >= 0) {
            key = key + ":" + priority;
        }
        return super.addMessageToGroup(key, message);
    }

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.isInstanceOf(String.class, (Object)groupId);
        List<String> list = this.sortedKeys((String)groupId);
        for (String key : list) {
            Message<?> message = super.pollMessageFromGroup(key);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private List<String> sortedKeys(String groupId) {
        Set keys = this.getRedisTemplate().keys((Object)(groupId == null ? this.getBeanName() + ":*" : groupId + "*"));
        LinkedList<String> list = new LinkedList<String>();
        for (Object key : keys) {
            Assert.isInstanceOf(String.class, key);
            list.add((String)key);
        }
        Collections.sort(list, this.keysComparator);
        return list;
    }

    @Override
    @ManagedAttribute
    public int getMessageGroupCount() {
        Set<Object> narrowedKeys = this.narrowedKeys();
        return narrowedKeys.size();
    }

    private Set<Object> narrowedKeys() {
        Set keys = this.getRedisTemplate().keys((Object)(this.getBeanName() + ":*"));
        HashSet<Object> narrowedKeys = new HashSet<Object>();
        for (Object key : keys) {
            Assert.isInstanceOf(String.class, key);
            String keyString = (String)key;
            int lastIndexOfColon = keyString.lastIndexOf(":");
            if (keyString.indexOf(":") != lastIndexOfColon) {
                narrowedKeys.add(keyString.substring(0, lastIndexOfColon));
                continue;
            }
            narrowedKeys.add(key);
        }
        return narrowedKeys;
    }

    @Override
    public void removeMessageGroup(Object groupId) {
        Assert.isInstanceOf(String.class, (Object)groupId);
        List<String> list = this.sortedKeys((String)groupId);
        for (String key : list) {
            super.removeMessageGroup(key);
        }
    }

    @Override
    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Set<Object> narrowedKeys = this.narrowedKeys();
        int count = 0;
        for (Object key : narrowedKeys) {
            count += this.messageGroupSize(key);
        }
        return count;
    }
}

