/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.integration.config.xml.AbstractInboundGatewayParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.inbound.RedisQueueInboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisQueueInboundGatewayParser
extends AbstractInboundGatewayParser {
    protected Class<?> getBeanClass(Element element) {
        return RedisQueueInboundGateway.class;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !attributeName.equals("queue") && !attributeName.equals("connection-factory") && !attributeName.equals("serializer") && !attributeName.equals("task-executor") && super.isEligibleAttribute(attributeName);
    }

    protected void doPostProcess(BeanDefinitionBuilder builder, Element element) {
        builder.addConstructorArgValue((Object)element.getAttribute("queue"));
        String connectionFactory = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactory)) {
            connectionFactory = "redisConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactory);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer", (boolean)true);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
    }
}

