/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.r2dbc.outbound;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReactiveMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class R2dbcMessageHandler
extends AbstractReactiveMessageHandler {
    private final R2dbcEntityOperations r2dbcEntityOperations;
    private final StatementMapper statementMapper;
    private StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private Expression queryTypeExpression = new ValueExpression((Object)Type.INSERT);
    @Nullable
    private Expression tableNameExpression;
    @Nullable
    private Expression valuesExpression;
    @Nullable
    private Expression criteriaExpression;
    private volatile boolean initialized = false;

    public R2dbcMessageHandler(R2dbcEntityOperations r2dbcEntityOperations) {
        Assert.notNull((Object)r2dbcEntityOperations, (String)"'r2dbcEntityOperations' must not be null");
        this.r2dbcEntityOperations = r2dbcEntityOperations;
        this.statementMapper = this.r2dbcEntityOperations.getDataAccessStrategy().getStatementMapper();
    }

    public void setQueryType(Type type) {
        this.setQueryTypeExpression((Expression)new ValueExpression((Object)type));
    }

    public void setQueryTypeExpression(Expression queryTypeExpression) {
        Assert.notNull((Object)queryTypeExpression, (String)"'queryTypeExpression' must not be null");
        this.queryTypeExpression = queryTypeExpression;
    }

    public void setTableName(String tableName) {
        this.setTableNameExpression((Expression)new LiteralExpression(tableName));
    }

    public void setTableNameExpression(Expression tableNameExpression) {
        this.tableNameExpression = tableNameExpression;
    }

    public void setValuesExpression(Expression valuesExpression) {
        this.valuesExpression = valuesExpression;
    }

    public void setCriteriaExpression(Expression criteriaExpression) {
        this.criteriaExpression = criteriaExpression;
    }

    public String getComponentType() {
        return "r2dbc:outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.data.relational.core.query");
        }
        this.initialized = true;
    }

    protected Mono<Void> handleMessageInternal(Message<?> message) {
        Assert.isTrue((boolean)this.initialized, (String)"The instance is not yet initialized. Invoke its afterPropertiesSet() method");
        return Mono.fromSupplier(() -> (Type)((Object)((Object)this.queryTypeExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Type.class)))).flatMap(mode -> switch (mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.handleInsert(message);
            case 1 -> this.handleUpdate(message);
            case 2 -> this.handleDelete(message);
        }).then();
    }

    private Mono<Void> handleDelete(Message<?> message) {
        if (this.tableNameExpression != null) {
            String tableName = (String)this.tableNameExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
            Assert.notNull((Object)tableName, (String)"'tableNameExpression' must not evaluate to null");
            Criteria criteria = this.evaluateCriteriaExpression(message);
            StatementMapper.DeleteSpec deleteSpec = this.statementMapper.createDelete(tableName).withCriteria((CriteriaDefinition)criteria);
            PreparedOperation operation = this.statementMapper.getMappedObject(deleteSpec);
            return this.r2dbcEntityOperations.getDatabaseClient().sql((Supplier)operation).then();
        }
        return this.r2dbcEntityOperations.delete(message.getPayload()).then();
    }

    private Mono<Void> handleUpdate(Message<?> message) {
        if (this.tableNameExpression != null) {
            String tableName = (String)this.tableNameExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
            Assert.notNull((Object)tableName, (String)"'tableNameExpression' must not evaluate to null");
            Map<String, Object> values = this.evaluateValuesExpression(message);
            Map<SqlIdentifier, Object> updateMap = this.transformIntoSqlIdentifierMap(values);
            Criteria criteria = this.evaluateCriteriaExpression(message);
            StatementMapper.UpdateSpec updateSpec = this.statementMapper.createUpdate(tableName, Update.from(updateMap)).withCriteria((CriteriaDefinition)criteria);
            PreparedOperation operation = this.statementMapper.getMappedObject(updateSpec);
            return this.r2dbcEntityOperations.getDatabaseClient().sql((Supplier)operation).then();
        }
        return this.r2dbcEntityOperations.update(message.getPayload()).then();
    }

    private Map<SqlIdentifier, Object> transformIntoSqlIdentifierMap(Map<String, Object> values) {
        HashMap<SqlIdentifier, Object> sqlIdentifierObjectMap = new HashMap<SqlIdentifier, Object>();
        values.forEach((k, v) -> sqlIdentifierObjectMap.put(SqlIdentifier.unquoted((String)k), v));
        return sqlIdentifierObjectMap;
    }

    private Mono<Void> handleInsert(Message<?> message) {
        if (this.tableNameExpression != null) {
            String tableName = (String)this.tableNameExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
            Assert.notNull((Object)tableName, (String)"'tableNameExpression' must not evaluate to null");
            Map<String, Object> values = this.evaluateValuesExpression(message);
            StatementMapper.InsertSpec insertSpec = this.statementMapper.createInsert(tableName);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                insertSpec = insertSpec.withColumn(entry.getKey(), Parameter.fromOrEmpty((Object)entry.getValue(), Object.class));
            }
            PreparedOperation operation = this.statementMapper.getMappedObject(insertSpec);
            return this.r2dbcEntityOperations.getDatabaseClient().sql((Supplier)operation).then();
        }
        return this.r2dbcEntityOperations.insert(message.getPayload()).then();
    }

    private Map<String, Object> evaluateValuesExpression(Message<?> message) {
        Assert.notNull((Object)this.valuesExpression, (String)"'this.valuesExpression' must not be null when 'tableNameExpression' mode is used");
        Map fieldValues = (Map)this.valuesExpression.getValue((EvaluationContext)this.evaluationContext, message, Map.class);
        Assert.notNull((Object)fieldValues, (String)"'valuesExpression' must not evaluate to null");
        return fieldValues;
    }

    private Criteria evaluateCriteriaExpression(Message<?> message) {
        Assert.notNull((Object)this.criteriaExpression, (String)"'this.criteriaExpression' must not be null when 'tableNameExpression' mode is used");
        Criteria criteria = (Criteria)this.criteriaExpression.getValue((EvaluationContext)this.evaluationContext, message, Criteria.class);
        Assert.notNull((Object)criteria, (String)"'criteriaExpression' must not evaluate to null");
        return criteria;
    }

    public static enum Type {
        INSERT,
        UPDATE,
        DELETE;

    }
}

