/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.aot;

import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class MqttRuntimeHints
implements RuntimeHintsRegistrar {
    MqttRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        Stream.of("org.eclipse.paho.client.mqttv3.MqttAsyncClient", "org.eclipse.paho.mqttv5.client.MqttAsyncClient").filter(typeName -> ClassUtils.isPresent((String)typeName, (ClassLoader)classLoader)).map(typeName -> MqttRuntimeHints.loadClassByName(typeName, classLoader)).flatMap(type -> Stream.ofNullable(ReflectionUtils.findMethod((Class)type, (String)"stopReconnectCycle"))).forEach(method -> reflectionHints.registerMethod(method, ExecutableMode.INVOKE));
    }

    private static Class<?> loadClassByName(String typeName, @Nullable ClassLoader classLoader) {
        try {
            return ClassUtils.forName((String)typeName, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

