/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;

public interface MqttMessageConverter
extends MessageConverter {
    default public @Nullable Message<?> toMessage(@Nullable String topic, MqttMessage mqttMessage) {
        AbstractIntegrationMessageBuilder<?> builder = this.toMessageBuilder(topic, mqttMessage);
        if (builder != null) {
            return builder.build();
        }
        return null;
    }

    public @Nullable AbstractIntegrationMessageBuilder<?> toMessageBuilder(@Nullable String var1, MqttMessage var2);

    public static MessageProcessor<Integer> defaultQosProcessor() {
        return message -> (Integer)message.getHeaders().get((Object)"mqtt_qos", Integer.class);
    }

    public static MessageProcessor<Boolean> defaultRetainedProcessor() {
        return message -> (Boolean)message.getHeaders().get((Object)"mqtt_retained", Boolean.class);
    }
}

