/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.util.Assert;

public class DefaultMqttPahoClientFactory
implements MqttPahoClientFactory {
    private MqttConnectOptions options = new MqttConnectOptions();
    private MqttClientPersistence persistence;

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public IMqttClient getClientInstance(String uri, String clientId) throws MqttException {
        return new MqttClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    @Override
    public IMqttAsyncClient getAsyncClientInstance(String uri, String clientId) throws MqttException {
        return new MqttAsyncClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    public void setConnectionOptions(MqttConnectOptions options) {
        Assert.notNull((Object)options, (String)"MqttConnectOptions cannot be null");
        this.options = options;
    }

    @Override
    public MqttConnectOptions getConnectionOptions() {
        return this.options;
    }

    public static class Will {
        private final String topic;
        private final byte[] payload;
        private final int qos;
        private final boolean retained;

        public Will(String topic, byte[] payload, int qos, boolean retained) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
        }

        protected String getTopic() {
            return this.topic;
        }

        protected byte[] getPayload() {
            return this.payload;
        }

        protected int getQos() {
            return this.qos;
        }

        protected boolean isRetained() {
            return this.retained;
        }
    }
}

