/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.metadata;

import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public class MongoDbMetadataStore
implements ConcurrentMetadataStore {
    private static final String KEY_MUST_NOT_BE_EMPTY = "'key' must not be empty.";
    private static final String DEFAULT_COLLECTION_NAME = "metadataStore";
    private static final String ID_FIELD = "_id";
    private static final String VALUE = "value";
    private final MongoTemplate template;
    private final String collectionName;

    public MongoDbMetadataStore(MongoDatabaseFactory factory) {
        this(factory, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbMetadataStore(MongoDatabaseFactory factory, String collectionName) {
        this(new MongoTemplate(factory), collectionName);
    }

    public MongoDbMetadataStore(MongoTemplate template) {
        this(template, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbMetadataStore(MongoTemplate template, String collectionName) {
        Assert.notNull((Object)template, (String)"'template' must not be null.");
        Assert.hasText((String)collectionName, (String)"'collectionName' must not be empty.");
        this.template = template;
        this.collectionName = collectionName;
    }

    public void put(String key, String value) {
        Assert.hasText((String)key, (String)KEY_MUST_NOT_BE_EMPTY);
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put(ID_FIELD, key);
        entry.put(VALUE, value);
        this.template.save((Object)new Document(entry), this.collectionName);
    }

    public @Nullable String get(String key) {
        Assert.hasText((String)key, (String)KEY_MUST_NOT_BE_EMPTY);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key));
        query.fields().exclude(ID_FIELD);
        Map result = (Map)this.template.findOne(query, Map.class, this.collectionName);
        return result == null ? null : (String)result.get(VALUE);
    }

    public @Nullable String remove(String key) {
        Assert.hasText((String)key, (String)KEY_MUST_NOT_BE_EMPTY);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key));
        query.fields().exclude(ID_FIELD);
        Map result = (Map)this.template.findAndRemove(query, Map.class, this.collectionName);
        return result == null ? null : (String)result.get(VALUE);
    }

    public @Nullable String putIfAbsent(String key, String value) {
        Assert.hasText((String)key, (String)KEY_MUST_NOT_BE_EMPTY);
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key));
        query.fields().exclude(ID_FIELD);
        Map result = (Map)this.template.findAndModify(query, (UpdateDefinition)new Update().setOnInsert(VALUE, (Object)value), new FindAndModifyOptions().upsert(true), Map.class, this.collectionName);
        return result == null ? null : (String)result.get(VALUE);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.hasText((String)key, (String)KEY_MUST_NOT_BE_EMPTY);
        Assert.hasText((String)oldValue, (String)"'oldValue' must not be empty.");
        Assert.hasText((String)newValue, (String)"'newValue' must not be empty.");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key).and(VALUE).is((Object)oldValue));
        return this.template.updateFirst(query, (UpdateDefinition)Update.update((String)VALUE, (Object)newValue), this.collectionName).getModifiedCount() > 0L;
    }
}

