/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.integration.mongodb.store.AbstractConfigurableMongoDbMessageStore;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ConfigurableMongoDbMessageStore
extends AbstractConfigurableMongoDbMessageStore
implements MessageStore {
    public static final String DEFAULT_COLLECTION_NAME = "configurableStoreMessages";

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        super(mongoTemplate, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDatabaseFactory mongoDbFactory) {
        this(mongoDbFactory, null, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDatabaseFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter) {
        this(mongoDbFactory, mappingMongoConverter, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDatabaseFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDatabaseFactory mongoDbFactory, @Nullable MappingMongoConverter mappingMongoConverter, String collectionName) {
        super(mongoDbFactory, mappingMongoConverter, collectionName);
    }

    public <T> Message<T> addMessage(Message<T> message) {
        this.addMessageDocument(new MessageDocument(message));
        return message;
    }

    public @Nullable Message<?> removeMessage(UUID id) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)id).and("groupId").exists(false));
        MessageDocument document = (MessageDocument)this.getMongoTemplate().findAndRemove(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public long getMessageCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(false));
        return this.getMongoTemplate().getCollection(this.collectionName).countDocuments((Bson)query.getQueryObject());
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.getMongoTemplate().findOne(query, MessageDocument.class, this.collectionName);
        if (messageDocument != null) {
            long createdTime = messageDocument.getGroupCreatedTime();
            long lastModifiedTime = messageDocument.getLastModifiedTime();
            boolean complete = messageDocument.isComplete();
            int lastReleasedSequence = messageDocument.getLastReleasedSequence();
            MessageGroup messageGroup = this.getMessageGroupFactory().create((MessageGroupStore)this, groupId, createdTime, complete);
            messageGroup.setLastModified(lastModifiedTime);
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequence);
            messageGroup.setCondition(messageDocument.getCondition());
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        this.addMessagesToGroup(groupId, new Message[]{message});
        return this.getMessageGroup(groupId);
    }

    @Override
    protected void doAddMessagesToGroup(Object groupId, Message<?> ... messages) {
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.getMongoTemplate().findOne(query, MessageDocument.class, this.collectionName);
        long createdTime = System.currentTimeMillis();
        int lastReleasedSequence = 0;
        boolean complete = false;
        String condition = null;
        if (messageDocument != null) {
            createdTime = messageDocument.getGroupCreatedTime();
            lastReleasedSequence = messageDocument.getLastReleasedSequence();
            complete = messageDocument.isComplete();
            condition = messageDocument.getCondition();
        }
        for (Message<?> message : messages) {
            MessageDocument document = new MessageDocument(message);
            document.setGroupId(groupId);
            document.setComplete(complete);
            document.setLastReleasedSequence(lastReleasedSequence);
            document.setGroupCreatedTime(createdTime);
            document.setLastModifiedTime(messageDocument == null ? createdTime : System.currentTimeMillis());
            document.setSequence(this.getNextId());
            if (condition != null) {
                document.setCondition(condition);
            }
            this.addMessageDocument(document);
        }
    }

    @Override
    protected void doRemoveMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Message<?> messageToRemove : messages) {
            ids.add(Objects.requireNonNull(messageToRemove.getHeaders().getId()));
            if (ids.size() < this.getRemoveBatchSize()) continue;
            this.removeMessages(groupId, ids);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            this.removeMessages(groupId, ids);
        }
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
    }

    public @Nullable Message<?> getMessageFromGroup(Object groupId, UUID messageId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageId).and("groupId").is(groupId));
        MessageDocument document = (MessageDocument)this.getMongoTemplate().findOne(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    protected boolean doRemoveMessageFromGroupById(Object groupId, UUID messageId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageId).and("groupId").is(groupId));
        return this.getMongoTemplate().remove(query, this.collectionName).wasAcknowledged();
    }

    private void removeMessages(Object groupId, Collection<UUID> ids) {
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).addCriteria((CriteriaDefinition)Criteria.where((String)"messageId").in(ids.toArray()));
        this.getMongoTemplate().remove(query, this.collectionName);
    }

    protected @Nullable Message<?> doPollMessageFromGroup(Object groupId) {
        Sort sort = Sort.by((String[])new String[]{"lastModifiedTime", "sequence"});
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
        MessageDocument document = (MessageDocument)this.getMongoTemplate().findAndRemove(query, MessageDocument.class, this.collectionName);
        Message<?> message = null;
        if (document != null) {
            message = document.getMessage();
            this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
        }
        return message;
    }

    @Override
    protected void doSetLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("lastReleasedSequence", (Object)sequenceNumber));
    }

    @Override
    protected void doSetGroupCondition(Object groupId, String condition) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("condition", (Object)condition));
    }

    @Override
    protected void doCompleteGroup(Object groupId) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("complete", (Object)true));
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        List groupIds = this.getMongoTemplate().findDistinct(query, "groupId", this.collectionName, Object.class);
        return StreamSupport.stream(groupIds.spliterator(), false).map(this::getMessageGroup).iterator();
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(true));
        long count = this.getMongoTemplate().count(query, this.collectionName);
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        return this.getMongoTemplate().findDistinct(query, "groupId", this.collectionName, Object.class).size();
    }

    public @Nullable Message<?> getOneMessageFromGroup(Object groupId) {
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.getMongoTemplate().findOne(query, MessageDocument.class, this.collectionName);
        if (messageDocument != null) {
            return messageDocument.getMessage();
        }
        return null;
    }

    @Override
    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        List documents = this.getMongoTemplate().find(query, MessageDocument.class, this.collectionName);
        return documents.stream().map(MessageDocument::getMessage).collect(Collectors.toList());
    }

    public Stream<Message<?>> streamMessagesForGroup(Object groupId) {
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        Stream documents = this.getMongoTemplate().stream(query, MessageDocument.class, this.collectionName);
        return documents.map(MessageDocument::getMessage);
    }

    private void updateGroup(Object groupId, Update update) {
        this.getMongoTemplate().findAndModify(ConfigurableMongoDbMessageStore.groupOrderQuery(groupId), (UpdateDefinition)update, FindAndModifyOptions.none(), Map.class, this.collectionName);
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)"lastModifiedTime", (Object)System.currentTimeMillis());
    }

    private static Query groupOrderQuery(Object groupId) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastModifiedTime", "sequence"});
        return ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
    }
}

