/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.ReactiveMessageHandlerAdapter;
import org.springframework.integration.mongodb.outbound.ReactiveMongoDbStoringMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.ReactiveMessageHandler;

public class ReactiveMongoDbMessageHandlerSpec
extends MessageHandlerSpec<ReactiveMongoDbMessageHandlerSpec, ReactiveMessageHandlerAdapter>
implements ComponentsRegistration {
    protected final ReactiveMongoDbStoringMessageHandler messageHandler;

    protected ReactiveMongoDbMessageHandlerSpec(ReactiveMongoDatabaseFactory mongoDbFactory) {
        this(new ReactiveMongoDbStoringMessageHandler(mongoDbFactory));
    }

    protected ReactiveMongoDbMessageHandlerSpec(ReactiveMongoOperations reactiveMongoOperations) {
        this(new ReactiveMongoDbStoringMessageHandler(reactiveMongoOperations));
    }

    private ReactiveMongoDbMessageHandlerSpec(ReactiveMongoDbStoringMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.target = new ReactiveMessageHandlerAdapter((ReactiveMessageHandler)this.messageHandler);
    }

    public ReactiveMongoDbMessageHandlerSpec mongoConverter(MongoConverter mongoConverter) {
        this.messageHandler.setMongoConverter(mongoConverter);
        return this;
    }

    public ReactiveMongoDbMessageHandlerSpec collectionName(String collectionName) {
        return this.collectionNameExpression((Expression)new LiteralExpression(collectionName));
    }

    public <P> ReactiveMongoDbMessageHandlerSpec collectionNameFunction(Function<Message<P>, String> collectionNameFunction) {
        return this.collectionNameExpression((Expression)new FunctionExpression(collectionNameFunction));
    }

    public ReactiveMongoDbMessageHandlerSpec collectionNameExpression(Expression collectionNameExpression) {
        this.messageHandler.setCollectionNameExpression(collectionNameExpression);
        return this;
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.messageHandler, null);
    }
}

