/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import jakarta.mail.Authenticator;
import jakarta.mail.FetchProfile;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMailReceiver
extends IntegrationObjectSupport
implements MailReceiver,
DisposableBean {
    public static final String DEFAULT_SI_USER_FLAG = "spring-integration-mail-adapter";
    private final URLName url;
    private final ReentrantReadWriteLock folderLock = new ReentrantReadWriteLock();
    private final Lock folderReadLock = this.folderLock.readLock();
    private final Lock folderWriteLock = this.folderLock.writeLock();
    private String protocol;
    private int maxFetchSize = -1;
    private Session session;
    private boolean shouldDeleteMessages;
    private int folderOpenMode = 1;
    private Properties javaMailProperties = new Properties();
    private Authenticator javaMailAuthenticator;
    private StandardEvaluationContext evaluationContext;
    private Expression selectorExpression;
    private HeaderMapper<MimeMessage> headerMapper;
    private String userFlag = "spring-integration-mail-adapter";
    private boolean embeddedPartsAsBytes = true;
    private boolean simpleContent;
    private boolean autoCloseFolder = true;
    private boolean flaggedAsFallback = true;
    private volatile Store store;
    private volatile Folder folder;

    public AbstractMailReceiver() {
        this.url = null;
    }

    public AbstractMailReceiver(URLName urlName) {
        Assert.notNull((Object)urlName, (String)"urlName must not be null");
        this.url = urlName;
    }

    public AbstractMailReceiver(String url) {
        this.url = url != null ? new URLName(url) : null;
    }

    public void setSelectorExpression(Expression selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void setProtocol(String protocol) {
        if (this.url != null) {
            Assert.isTrue((boolean)this.url.getProtocol().equals(protocol), (String)"The 'protocol' does not match that provided by the Store URI.");
        }
        this.protocol = protocol;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    protected Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.javaMailAuthenticator = javaMailAuthenticator;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void setShouldDeleteMessages(boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    protected boolean shouldDeleteMessages() {
        return this.shouldDeleteMessages;
    }

    protected String getUserFlag() {
        return this.userFlag;
    }

    public void setUserFlag(String userFlag) {
        this.userFlag = userFlag;
    }

    public void setHeaderMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setEmbeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.embeddedPartsAsBytes = embeddedPartsAsBytes;
    }

    public void setSimpleContent(boolean simpleContent) {
        this.simpleContent = simpleContent;
    }

    public void setAutoCloseFolder(boolean autoCloseFolder) {
        this.autoCloseFolder = autoCloseFolder;
    }

    public void setFlaggedAsFallback(boolean flaggedAsFallback) {
        this.flaggedAsFallback = flaggedAsFallback;
    }

    protected Folder getFolder() {
        return this.folder;
    }

    protected int getFolderOpenMode() {
        return this.folderOpenMode;
    }

    protected abstract Message[] searchForNewMessages() throws jakarta.mail.MessagingException;

    private void openSession() {
        if (this.session == null) {
            this.session = this.javaMailAuthenticator != null ? Session.getInstance((Properties)this.javaMailProperties, (Authenticator)this.javaMailAuthenticator) : Session.getInstance((Properties)this.javaMailProperties);
        }
    }

    private void connectStoreIfNecessary() throws jakarta.mail.MessagingException {
        if (this.store == null) {
            this.store = this.url != null ? this.session.getStore(this.url) : (this.protocol != null ? this.session.getStore(this.protocol) : this.session.getStore());
        }
        if (!this.store.isConnected()) {
            this.logger.debug(() -> "connecting to store [" + String.valueOf(this.store.getURLName()) + "]");
            this.store.connect();
        }
    }

    protected void openFolder() throws jakarta.mail.MessagingException {
        if (this.folder == null) {
            this.openSession();
            this.connectStoreIfNecessary();
            this.folder = this.obtainFolderInstance();
        } else {
            this.connectStoreIfNecessary();
        }
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("no such folder [" + this.url.getFile() + "]");
        }
        if (this.folder.isOpen()) {
            return;
        }
        URLName urlName = this.folder.getURLName();
        this.logger.debug(() -> "opening folder [" + String.valueOf(urlName) + "]");
        this.folder.open(this.folderOpenMode);
    }

    private Folder obtainFolderInstance() throws jakarta.mail.MessagingException {
        return this.store.getFolder(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] receive() throws jakarta.mail.MessagingException {
        this.folderReadLock.lock();
        try {
            Object[] objectArray;
            Object[] messagesToReturn = null;
            try {
                Folder folderToCheck = this.getFolder();
                if (folderToCheck == null || !folderToCheck.isOpen()) {
                    this.folderReadLock.unlock();
                    this.folderWriteLock.lock();
                    try {
                        this.openFolder();
                        this.folderReadLock.lock();
                    }
                    finally {
                        this.folderWriteLock.unlock();
                    }
                }
                objectArray = messagesToReturn = this.convertMessagesIfNecessary(this.searchAndFilterMessages());
            }
            catch (Throwable throwable) {
                if (this.autoCloseFolder || ObjectUtils.isEmpty(messagesToReturn)) {
                    this.closeFolder();
                }
                throw throwable;
            }
            if (this.autoCloseFolder || ObjectUtils.isEmpty((Object[])messagesToReturn)) {
                this.closeFolder();
            }
            return objectArray;
        }
        finally {
            if (this.folderLock.getReadHoldCount() > 0) {
                this.folderReadLock.unlock();
            }
        }
    }

    protected void closeFolder() {
        this.folderReadLock.lock();
        try {
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
        }
        finally {
            this.folderReadLock.unlock();
        }
    }

    private MimeMessage[] searchAndFilterMessages() throws jakarta.mail.MessagingException {
        Message[] messagesToProcess;
        this.logger.debug(() -> "attempting to receive mail from folder [" + this.folder.getFullName() + "]");
        Message[] messages = this.searchForNewMessages();
        if (this.maxFetchSize > 0 && messages.length > this.maxFetchSize) {
            Message[] reducedMessages = new Message[this.maxFetchSize];
            System.arraycopy(messages, 0, reducedMessages, 0, this.maxFetchSize);
            messagesToProcess = reducedMessages;
        } else {
            messagesToProcess = messages;
        }
        this.logger.debug(() -> "found " + messagesToProcess.length + " new messages");
        if (messagesToProcess.length > 0) {
            this.fetchMessages(messagesToProcess);
        }
        this.logger.debug(() -> "Received " + messagesToProcess.length + " messages");
        MimeMessage[] filteredMessages = this.filterMessagesThruSelector(messagesToProcess);
        this.postProcessFilteredMessages((Message[])filteredMessages);
        return filteredMessages;
    }

    private Object[] convertMessagesIfNecessary(MimeMessage[] filteredMessages) {
        if (this.headerMapper != null || !this.autoCloseFolder) {
            Object[] converted = new org.springframework.messaging.Message[filteredMessages.length];
            int n = 0;
            MimeMessage[] mimeMessageArray = filteredMessages;
            int n2 = mimeMessageArray.length;
            for (int i = 0; i < n2; ++i) {
                MimeMessage message;
                Object payload = message = mimeMessageArray[i];
                Map headers = null;
                if (this.headerMapper != null) {
                    headers = this.headerMapper.toHeaders((Object)message);
                    payload = this.extractContent(message, headers);
                }
                AbstractIntegrationMessageBuilder messageBuilder = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers);
                if (!this.autoCloseFolder) {
                    messageBuilder.setHeader("closeableResource", this::closeFolder);
                }
                converted[n++] = messageBuilder.build();
            }
            return converted;
        }
        return filteredMessages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object extractContent(MimeMessage message, Map<String, Object> headers) {
        try {
            Object content;
            MimeMessage theMessage = message;
            if (this.simpleContent) {
                theMessage = new IntegrationMimeMessage(message);
            }
            if ((content = theMessage.getContent()) instanceof String) {
                String mailContentType = (String)headers.get("mail_contentType");
                if (MimeTypeUtils.TEXT_PLAIN.getType().equals(mailContentType)) {
                    headers.put("contentType", mailContentType);
                    return content;
                } else {
                    headers.put("contentType", "text/plain");
                }
                return content;
            } else {
                if (content instanceof InputStream) {
                    InputStream inputStream = (InputStream)content;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    FileCopyUtils.copy((InputStream)inputStream, (OutputStream)baos);
                    return this.byteArrayToContent(headers, baos);
                }
                if (content instanceof Multipart) {
                    Multipart multipart = (Multipart)content;
                    if (this.embeddedPartsAsBytes) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        multipart.writeTo((OutputStream)baos);
                        return this.byteArrayToContent(headers, baos);
                    }
                }
                if (!(content instanceof Part)) return content;
                Part part = (Part)content;
                if (!this.embeddedPartsAsBytes) return content;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                part.writeTo((OutputStream)baos);
                return this.byteArrayToContent(headers, baos);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Failed to extract content from " + String.valueOf(message), (Throwable)e);
        }
    }

    private Object byteArrayToContent(Map<String, Object> headers, ByteArrayOutputStream baos) {
        headers.put("contentType", "application/octet-stream");
        return baos.toByteArray();
    }

    private void postProcessFilteredMessages(Message[] filteredMessages) throws jakarta.mail.MessagingException {
        Message[] messages = filteredMessages;
        if (this.headerMapper == null && (this.autoCloseFolder || this.simpleContent)) {
            messages = new Message[filteredMessages.length];
            for (int i = 0; i < filteredMessages.length; ++i) {
                Message originalMessage;
                messages[i] = originalMessage = filteredMessages[i];
                IntegrationMimeMessage mimeMessage = new IntegrationMimeMessage((MimeMessage)originalMessage);
                filteredMessages[i] = mimeMessage;
            }
        }
        this.setMessageFlagsAndMaybeDeleteMessages(messages);
        if (filteredMessages.length > 0 && filteredMessages[0] instanceof IntegrationMimeMessage) {
            this.setMessageFlagsAndMaybeDeleteMessages(filteredMessages);
        }
    }

    private void setMessageFlagsAndMaybeDeleteMessages(Message[] messages) throws jakarta.mail.MessagingException {
        this.setMessageFlags(messages);
        if (this.shouldDeleteMessages()) {
            this.deleteMessages(messages);
        }
    }

    private void setMessageFlags(Message[] filteredMessages) throws jakarta.mail.MessagingException {
        boolean recentFlagSupported = false;
        Flags flags = this.getFolder().getPermanentFlags();
        if (flags != null) {
            recentFlagSupported = flags.contains(Flags.Flag.RECENT);
        }
        for (Message message : filteredMessages) {
            if (!recentFlagSupported) {
                if (flags != null && flags.contains(Flags.Flag.USER)) {
                    this.logger.debug(() -> "USER flags are supported by this mail server. Flagging message with '" + this.userFlag + "' user flag");
                    Flags siFlags = new Flags();
                    siFlags.add(this.userFlag);
                    message.setFlags(siFlags, true);
                } else if (this.flaggedAsFallback) {
                    this.logger.debug((CharSequence)"USER flags are not supported by this mail server. Flagging message with system flag");
                    message.setFlag(Flags.Flag.FLAGGED, true);
                }
            }
            this.setAdditionalFlags(message);
        }
    }

    private MimeMessage[] filterMessagesThruSelector(Message[] messages) throws jakarta.mail.MessagingException {
        LinkedList<MimeMessage> filteredMessages = new LinkedList<MimeMessage>();
        for (Message message1 : messages) {
            MimeMessage message = (MimeMessage)message1;
            if (this.selectorExpression != null) {
                if (Boolean.TRUE.equals(this.selectorExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Boolean.class))) {
                    filteredMessages.add(message);
                    continue;
                }
                if (message.isExpunged()) {
                    this.logger.debug((CharSequence)"Expunged message discarded and will not be further processed.");
                    continue;
                }
                String subject = message.getSubject();
                this.logger.debug(() -> "Fetched email with subject '" + subject + "' will be discarded by the matching filter and will not be flagged as SEEN.");
                continue;
            }
            filteredMessages.add(message);
        }
        return filteredMessages.toArray(new MimeMessage[0]);
    }

    protected void fetchMessages(Message[] messages) throws jakarta.mail.MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        this.folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Message[] messages) throws jakarta.mail.MessagingException {
        for (Message message : messages) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }

    protected void setAdditionalFlags(Message message) throws jakarta.mail.MessagingException {
    }

    public void destroy() {
        this.folderWriteLock.lock();
        try {
            this.closeFolder();
            MailTransportUtils.closeService((Service)this.store);
            this.folder = null;
            this.store = null;
        }
        finally {
            this.folderWriteLock.unlock();
        }
    }

    protected void onInit() {
        super.onInit();
        this.folderOpenMode = 2;
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    public String toString() {
        return this.url.toString();
    }

    Store getStore() {
        return this.store;
    }

    private final class IntegrationMimeMessage
    extends MimeMessage {
        private final MimeMessage source;
        private final Object content;

        IntegrationMimeMessage(MimeMessage source) throws jakarta.mail.MessagingException {
            super(source);
            this.source = source;
            if (AbstractMailReceiver.this.simpleContent) {
                this.content = null;
            } else {
                Object complexContent;
                try {
                    complexContent = source.getContent();
                }
                catch (IOException ex) {
                    complexContent = "Unable to extract content; see logs: " + ex.getMessage();
                    AbstractMailReceiver.this.logger.error((Throwable)ex, () -> "Failed to extract content from " + String.valueOf(source));
                }
                this.content = complexContent;
            }
        }

        public Folder getFolder() {
            if (!AbstractMailReceiver.this.autoCloseFolder) {
                return AbstractMailReceiver.this.folder;
            }
            try {
                return AbstractMailReceiver.this.obtainFolderInstance();
            }
            catch (jakarta.mail.MessagingException e) {
                throw new MessagingException("Unable to obtain the mail folder", (Throwable)e);
            }
        }

        public Date getReceivedDate() throws jakarta.mail.MessagingException {
            return this.source.getReceivedDate();
        }

        public int getLineCount() throws jakarta.mail.MessagingException {
            return this.source.getLineCount();
        }

        public Object getContent() throws IOException, jakarta.mail.MessagingException {
            if (AbstractMailReceiver.this.simpleContent) {
                return super.getContent();
            }
            return this.content;
        }
    }
}

