/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import java.util.Map;
import javax.mail.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.mail.support.MailUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;

public abstract class AbstractMailMessageTransformer<T>
implements Transformer,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public org.springframework.messaging.Message<?> transform(org.springframework.messaging.Message<?> message) {
        Object payload = message.getPayload();
        if (!(payload instanceof Message)) {
            throw new MessageTransformationException(message, this.getClass().getSimpleName() + " requires a javax.mail.Message payload");
        }
        Message mailMessage = (Message)payload;
        AbstractIntegrationMessageBuilder<T> builder = null;
        try {
            builder = this.doTransform(mailMessage);
        }
        catch (Exception e) {
            throw new MessageTransformationException(message, "failed to transform mail message", (Throwable)e);
        }
        if (builder == null) {
            throw new MessageTransformationException(message, "failed to transform mail message");
        }
        builder.copyHeaders(this.extractHeaderMapFromMailMessage(mailMessage));
        return builder.build();
    }

    protected abstract AbstractIntegrationMessageBuilder<T> doTransform(Message var1) throws Exception;

    private Map<String, Object> extractHeaderMapFromMailMessage(Message mailMessage) {
        return MailUtils.extractStandardHeaders(mailMessage);
    }
}

