/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.kafka.dsl.KafkaTemplateSpec;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class KafkaProducerMessageHandlerSpec<K, V, S extends KafkaProducerMessageHandlerSpec<K, V, S>>
extends MessageHandlerSpec<S, KafkaProducerMessageHandler<K, V>> {
    KafkaProducerMessageHandlerSpec(KafkaTemplate<K, V> kafkaTemplate) {
        this.target = new KafkaProducerMessageHandler<K, V>(kafkaTemplate);
    }

    public S topic(String topic) {
        return this.topicExpression((Expression)new LiteralExpression(topic));
    }

    public S topicExpression(String topicExpression) {
        return this.topicExpression(PARSER.parseExpression(topicExpression));
    }

    public S topicExpression(Expression topicExpression) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setTopicExpression(topicExpression);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public <P> S topic(Function<Message<P>, String> topicFunction) {
        return this.topicExpression((Expression)new FunctionExpression(topicFunction));
    }

    public S messageKeyExpression(String messageKeyExpression) {
        return this.messageKeyExpression(PARSER.parseExpression(messageKeyExpression));
    }

    public S messageKey(String messageKey) {
        return this.messageKeyExpression((Expression)new LiteralExpression(messageKey));
    }

    public S messageKeyExpression(Expression messageKeyExpression) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setMessageKeyExpression(messageKeyExpression);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public <P> S messageKey(Function<Message<P>, ?> messageKeyFunction) {
        return this.messageKeyExpression((Expression)new FunctionExpression(messageKeyFunction));
    }

    public S partitionId(Integer partitionId) {
        return this.partitionIdExpression((Expression)new ValueExpression((Object)partitionId));
    }

    public S partitionIdExpression(String partitionIdExpression) {
        return this.partitionIdExpression(PARSER.parseExpression(partitionIdExpression));
    }

    public <P> S partitionId(Function<Message<P>, Integer> partitionIdFunction) {
        return this.partitionIdExpression((Expression)new FunctionExpression(partitionIdFunction));
    }

    public S partitionIdExpression(Expression partitionIdExpression) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setPartitionIdExpression(partitionIdExpression);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S timestampExpression(String timestampExpression) {
        return this.timestampExpression(PARSER.parseExpression(timestampExpression));
    }

    public <P> S timestamp(Function<Message<P>, Long> timestampFunction) {
        return this.timestampExpression((Expression)new FunctionExpression(timestampFunction));
    }

    public S timestampExpression(Expression timestampExpression) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setTimestampExpression(timestampExpression);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S flushExpression(String flushExpression) {
        return this.flushExpression(PARSER.parseExpression(flushExpression));
    }

    public <P> S flush(Function<Message<P>, Boolean> flushFunction) {
        return this.flushExpression((Expression)new FunctionExpression(flushFunction));
    }

    public S flushExpression(Expression flushExpression) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setFlushExpression(flushExpression);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sync(boolean sync) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSync(sync);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sendTimeout(long sendTimeout) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSendTimeout(sendTimeout);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S headerMapper(KafkaHeaderMapper mapper) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setHeaderMapper(mapper);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sendSuccessChannel(MessageChannel sendSuccessChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSendSuccessChannel(sendSuccessChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sendSuccessChannel(String sendSuccessChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSendSuccessChannelName(sendSuccessChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sendFailureChannel(MessageChannel sendFailureChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSendFailureChannel(sendFailureChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S sendFailureChannel(String sendFailureChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setSendFailureChannelName(sendFailureChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S futuresChannel(MessageChannel futuresChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setFuturesChannel(futuresChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S futuresChannel(String futuresChannel) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setFuturesChannelName(futuresChannel);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S producerRecordCreator(KafkaProducerMessageHandler.ProducerRecordCreator<K, V> creator) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setProducerRecordCreator(creator);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public S useTemplateConverter(boolean use) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setUseTemplateConverter(use);
        return (S)((Object)((KafkaProducerMessageHandlerSpec)this._this()));
    }

    public static class KafkaProducerMessageHandlerTemplateSpec<K, V>
    extends KafkaProducerMessageHandlerSpec<K, V, KafkaProducerMessageHandlerTemplateSpec<K, V>>
    implements ComponentsRegistration {
        private final KafkaTemplateSpec<K, V> kafkaTemplateSpec;

        KafkaProducerMessageHandlerTemplateSpec(ProducerFactory<K, V> producerFactory) {
            super(new KafkaTemplate(producerFactory));
            this.kafkaTemplateSpec = new KafkaTemplateSpec(((KafkaProducerMessageHandler)((Object)this.target)).getKafkaTemplate());
        }

        public KafkaProducerMessageHandlerTemplateSpec<K, V> configureKafkaTemplate(Consumer<KafkaTemplateSpec<K, V>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.kafkaTemplateSpec);
            return (KafkaProducerMessageHandlerTemplateSpec)this._this();
        }

        public Map<Object, @Nullable String> getComponentsToRegister() {
            return Collections.singletonMap(this.kafkaTemplateSpec.getTemplate(), this.kafkaTemplateSpec.getId());
        }
    }
}

