/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.integration.core.RecoveryCallback;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.support.Acknowledgment;

public interface KafkaInboundEndpoint {
    public static final String CONTEXT_ACKNOWLEDGMENT = "acknowledgment";
    public static final String CONTEXT_CONSUMER = "consumer";
    public static final String CONTEXT_RECORD = "record";
    public static final ThreadLocal<@Nullable AttributeAccessor> ATTRIBUTES_HOLDER = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void doWithRetry(RetryTemplate template, @Nullable RecoveryCallback<?> callback, ConsumerRecord<?, ?> record, @Nullable Acknowledgment acknowledgment, @Nullable Consumer<?, ?> consumer, Runnable runnable) {
        block6: {
            RetryContext context = new RetryContext();
            context.setAttribute(CONTEXT_RECORD, record);
            context.setAttribute(CONTEXT_ACKNOWLEDGMENT, acknowledgment);
            context.setAttribute(CONTEXT_CONSUMER, consumer);
            ATTRIBUTES_HOLDER.set((AttributeAccessor)context);
            try {
                template.execute(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable ex) {
                        ++context.retryCount;
                        throw ex;
                    }
                    return null;
                });
            }
            catch (RetryException ex) {
                if (callback != null) {
                    callback.recover((AttributeAccessor)context, (Throwable)ex);
                    break block6;
                }
                throw new KafkaException("Failed to execute runnable", (Throwable)ex);
            }
            finally {
                ATTRIBUTES_HOLDER.remove();
            }
        }
    }

    public static final class RetryContext
    extends AttributeAccessorSupport {
        private int retryCount;

        public int getRetryCount() {
            return this.retryCount;
        }
    }
}

