/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.core.AttributeAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;

public interface KafkaInboundEndpoint {
    public static final String CONTEXT_ACKNOWLEDGMENT = "acknowledgment";
    public static final String CONTEXT_CONSUMER = "consumer";
    public static final String CONTEXT_RECORD = "record";
    public static final ThreadLocal<AttributeAccessor> ATTRIBUTES_HOLDER = new ThreadLocal();

    default public void doWithRetry(RetryTemplate template, @Nullable RecoveryCallback<?> callback, ConsumerRecord<?, ?> record, @Nullable Acknowledgment acknowledgment, @Nullable Consumer<?, ?> consumer, Runnable runnable) {
        try {
            template.execute(context -> {
                if (context.getRetryCount() == 0) {
                    context.setAttribute(CONTEXT_RECORD, (Object)record);
                    context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                    context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                    ATTRIBUTES_HOLDER.set((AttributeAccessor)context);
                }
                runnable.run();
                return null;
            }, callback);
        }
        catch (Exception ex) {
            throw new KafkaException("Failed to execute runnable", (Throwable)ex);
        }
        finally {
            ATTRIBUTES_HOLDER.remove();
        }
    }
}

