/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.springframework.integration.kafka.dsl.KafkaInboundChannelAdapterSpec;
import org.springframework.integration.kafka.dsl.KafkaInboundGatewaySpec;
import org.springframework.integration.kafka.dsl.KafkaMessageDrivenChannelAdapterSpec;
import org.springframework.integration.kafka.dsl.KafkaMessageListenerContainerSpec;
import org.springframework.integration.kafka.dsl.KafkaOutboundGatewaySpec;
import org.springframework.integration.kafka.dsl.KafkaProducerMessageHandlerSpec;
import org.springframework.integration.kafka.dsl.KafkaTemplateSpec;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.integration.kafka.inbound.KafkaMessageSource;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.GenericMessageListenerContainer;
import org.springframework.kafka.requestreply.ReplyingKafkaTemplate;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.TopicPartitionOffset;

public final class Kafka {
    public static <K, V> KafkaProducerMessageHandlerSpec<K, V, ?> outboundChannelAdapter(KafkaTemplate<K, V> kafkaTemplate) {
        return new KafkaProducerMessageHandlerSpec(kafkaTemplate);
    }

    public static <K, V> KafkaProducerMessageHandlerSpec.KafkaProducerMessageHandlerTemplateSpec<K, V> outboundChannelAdapter(ProducerFactory<K, V> producerFactory) {
        return new KafkaProducerMessageHandlerSpec.KafkaProducerMessageHandlerTemplateSpec<K, V>(producerFactory);
    }

    public static <K, V> KafkaInboundChannelAdapterSpec<K, V> inboundChannelAdapter(ConsumerFactory<K, V> consumerFactory, String ... topics) {
        return Kafka.inboundChannelAdapter(consumerFactory, false, topics);
    }

    public static <K, V> KafkaInboundChannelAdapterSpec<K, V> inboundChannelAdapter(ConsumerFactory<K, V> consumerFactory, boolean allowMultiFetch, String ... topics) {
        return new KafkaInboundChannelAdapterSpec<K, V>(consumerFactory, allowMultiFetch, topics);
    }

    public static <K, V> KafkaInboundChannelAdapterSpec<K, V> inboundChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageSource.KafkaAckCallbackFactory<K, V> ackCallbackFactory, String ... topics) {
        return Kafka.inboundChannelAdapter(consumerFactory, ackCallbackFactory, false, topics);
    }

    public static <K, V> KafkaInboundChannelAdapterSpec<K, V> inboundChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageSource.KafkaAckCallbackFactory<K, V> ackCallbackFactory, boolean allowMultiFetch, String ... topics) {
        return new KafkaInboundChannelAdapterSpec<K, V>(consumerFactory, ackCallbackFactory, allowMultiFetch, topics);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec<K, V, ?> messageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> listenerContainer) {
        return Kafka.messageDrivenChannelAdapter(listenerContainer, KafkaMessageDrivenChannelAdapter.ListenerMode.record);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec<K, V, ?> messageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> listenerContainer, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
        return new KafkaMessageDrivenChannelAdapterSpec(listenerContainer, listenerMode);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
        return Kafka.messageDrivenChannelAdapter(consumerFactory, containerProperties, KafkaMessageDrivenChannelAdapter.ListenerMode.record);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
        return Kafka.messageDrivenChannelAdapter(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, containerProperties), listenerMode);
    }

    @Deprecated
    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, TopicPartitionInitialOffset ... topicPartitions) {
        return Kafka.messageDrivenChannelAdapter(consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode.record, topicPartitions);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, TopicPartitionOffset ... topicPartitions) {
        return Kafka.messageDrivenChannelAdapter(consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode.record, topicPartitions);
    }

    @Deprecated
    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode, TopicPartitionInitialOffset ... topicPartitions) {
        return Kafka.messageDrivenChannelAdapter(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, (TopicPartitionOffset[])Arrays.stream(topicPartitions).map(TopicPartitionInitialOffset::toTPO).toArray(TopicPartitionOffset[]::new)), listenerMode);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode, TopicPartitionOffset ... topicPartitions) {
        return Kafka.messageDrivenChannelAdapter(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, topicPartitions), listenerMode);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, String ... topics) {
        return Kafka.messageDrivenChannelAdapter(consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode.record, topics);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode, String ... topics) {
        return Kafka.messageDrivenChannelAdapter(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, topics), listenerMode);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
        return Kafka.messageDrivenChannelAdapter(consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode.record, topicPattern);
    }

    public static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(ConsumerFactory<K, V> consumerFactory, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode, Pattern topicPattern) {
        return Kafka.messageDrivenChannelAdapter(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, topicPattern), listenerMode);
    }

    public static <K, V, R> KafkaOutboundGatewaySpec<K, V, R, ?> outboundGateway(ReplyingKafkaTemplate<K, V, R> kafkaTemplate) {
        return new KafkaOutboundGatewaySpec(kafkaTemplate);
    }

    public static <K, V, R> KafkaOutboundGatewaySpec.KafkaGatewayMessageHandlerTemplateSpec<K, V, R> outboundGateway(ProducerFactory<K, V> producerFactory, GenericMessageListenerContainer<K, R> replyContainer) {
        return new KafkaOutboundGatewaySpec.KafkaGatewayMessageHandlerTemplateSpec<K, V, R>(producerFactory, replyContainer);
    }

    public static <K, V, R> KafkaInboundGatewaySpec<K, V, R, ?> inboundGateway(AbstractMessageListenerContainer<K, V> container, KafkaTemplate<K, R> template) {
        return new KafkaInboundGatewaySpec(container, template);
    }

    public static <K, V, R> KafkaInboundGatewaySpec.KafkaInboundGatewayListenerContainerSpec<K, V, R> inboundGateway(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties, ProducerFactory<K, R> producerFactory) {
        return Kafka.inboundGateway(new KafkaMessageListenerContainerSpec<K, V>(consumerFactory, containerProperties), new KafkaTemplateSpec<K, R>(producerFactory));
    }

    public static <K, V, R> KafkaInboundGatewaySpec.KafkaInboundGatewayListenerContainerSpec<K, V, R> inboundGateway(KafkaMessageListenerContainerSpec<K, V> containerSpec, KafkaTemplateSpec<K, R> templateSpec) {
        return new KafkaInboundGatewaySpec.KafkaInboundGatewayListenerContainerSpec<K, V, R>(containerSpec, templateSpec);
    }

    private static <K, V> KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> messageDrivenChannelAdapter(KafkaMessageListenerContainerSpec<K, V> spec, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
        return new KafkaMessageDrivenChannelAdapterSpec.KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>(spec, listenerMode);
    }

    private Kafka() {
    }
}

