/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.w3c.dom.Element;

public final class KafkaParsingUtils {
    private KafkaParsingUtils() {
    }

    public static void commonOutboundProperties(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinition timestampExpressionDef;
        BeanDefinition partitionIdExpressionDef;
        BeanDefinition messageKeyExpressionDef;
        String kafkaTemplateBeanName = element.getAttribute("kafka-template");
        builder.addConstructorArgReference(kafkaTemplateBeanName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-message-strategy");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-failure-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-success-channel");
        BeanDefinition topicExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"topic", (String)"topic-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (topicExpressionDef != null) {
            builder.addPropertyValue("topicExpression", (Object)topicExpressionDef);
        }
        if ((messageKeyExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"message-key", (String)"message-key-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            builder.addPropertyValue("messageKeyExpression", (Object)messageKeyExpressionDef);
        }
        if ((partitionIdExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"partition-id", (String)"partition-id-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            builder.addPropertyValue("partitionIdExpression", (Object)partitionIdExpressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"sync");
        BeanDefinition sendTimeoutExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"send-timeout", (String)"send-timeout-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (sendTimeoutExpressionDef != null) {
            builder.addPropertyValue("sendTimeoutExpression", (Object)sendTimeoutExpressionDef);
        }
        if ((timestampExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"timestamp-expression", (Element)element)) != null) {
            builder.addPropertyValue("timestampExpression", (Object)timestampExpressionDef);
        }
    }
}

