/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.inbound.KafkaMessageSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class KafkaInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(KafkaMessageSource.class);
        builder.addConstructorArgReference(element.getAttribute("consumer-factory"));
        String attribute = element.getAttribute("ack-factory");
        if (StringUtils.hasText((String)attribute)) {
            builder.addConstructorArgReference(attribute);
        }
        if (StringUtils.hasText((String)(attribute = element.getAttribute("allow-multi-fetch")))) {
            builder.addConstructorArgValue((Object)attribute);
        }
        builder.addConstructorArgValue((Object)element.getAttribute("topics"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"client-id");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"group-id");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"payload-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"raw-header", (String)"rawMessageHeader");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"rebalance-listener");
        return builder.getBeanDefinition();
    }
}

