/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class JpaParserUtils {
    private static final LogAccessor LOGGER = new LogAccessor(JpaParserUtils.class);

    public static BeanDefinitionBuilder getJpaExecutorBuilder(Element element, ParserContext parserContext) {
        ManagedList<BeanDefinition> jpaParameterList;
        Assert.notNull((Object)element, (String)"The provided element must not be null.");
        Assert.notNull((Object)parserContext, (String)"The provided parserContext must not be null.");
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder jpaExecutorBuilder = BeanDefinitionBuilder.genericBeanDefinition(JpaExecutor.class);
        int attributeCount = 0;
        String entityManagerRef = element.getAttribute("entity-manager");
        String entityManagerFactoryRef = element.getAttribute("entity-manager-factory");
        String jpaOperationsRef = element.getAttribute("jpa-operations");
        if (StringUtils.hasText((String)jpaOperationsRef)) {
            ++attributeCount;
            jpaExecutorBuilder.addConstructorArgReference(jpaOperationsRef);
        }
        if (StringUtils.hasText((String)entityManagerRef)) {
            if (attributeCount > 0) {
                parserContext.getReaderContext().error("Exactly only one of the attributes 'entity-manager' or 'entity-manager-factory' or 'jpa-operations' must be set.", source);
            }
            ++attributeCount;
            jpaExecutorBuilder.addConstructorArgReference(entityManagerRef);
        }
        if (StringUtils.hasText((String)entityManagerFactoryRef)) {
            if (attributeCount > 0) {
                parserContext.getReaderContext().error("Exactly only one of the attributes 'entity-manager' or 'entity-manager-factory' or 'jpa-operations' must be set.", source);
            }
            ++attributeCount;
            jpaExecutorBuilder.addConstructorArgReference(entityManagerFactoryRef);
        }
        if (attributeCount == 0) {
            parserContext.getReaderContext().error("Exactly one of the attributes 'entity-manager' or 'entity-manager-factory' or 'jpa-operations' must be set.", source);
        }
        if (!(jpaParameterList = JpaParserUtils.getJpaParameterBeanDefinitions(element, parserContext)).isEmpty()) {
            jpaExecutorBuilder.addPropertyValue("jpaParameters", jpaParameterList);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"entity-class");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"jpa-query");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"native-query");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"named-query");
        return jpaExecutorBuilder;
    }

    public static BeanDefinitionBuilder getOutboundGatewayJpaExecutorBuilder(Element gatewayElement, ParserContext parserContext) {
        BeanDefinitionBuilder jpaExecutorBuilder = JpaParserUtils.getJpaExecutorBuilder(gatewayElement, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"parameter-source-factory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"use-payload-as-parameter-source");
        return jpaExecutorBuilder;
    }

    public static ManagedList<BeanDefinition> getJpaParameterBeanDefinitions(Element jpaComponent, ParserContext parserContext) {
        Assert.notNull((Object)jpaComponent, (String)"The provided element must not be null.");
        Assert.notNull((Object)parserContext, (String)"The provided parserContext must not be null.");
        ManagedList parameterList = new ManagedList();
        List parameterChildElements = DomUtils.getChildElementsByTagName((Element)jpaComponent, (String)"parameter");
        for (Element childElement : parameterChildElements) {
            BeanDefinitionBuilder parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(JpaParameter.class);
            String name = childElement.getAttribute("name");
            String expression = childElement.getAttribute("expression");
            String value = childElement.getAttribute("value");
            String type = childElement.getAttribute("type");
            if (StringUtils.hasText((String)name)) {
                parameterBuilder.addPropertyValue("name", (Object)name);
            }
            if (StringUtils.hasText((String)expression)) {
                parameterBuilder.addPropertyValue("expression", (Object)expression);
            }
            if (StringUtils.hasText((String)value)) {
                if (!StringUtils.hasText((String)type)) {
                    LOGGER.info(() -> String.format("Type attribute not set for parameter '%s'. Defaulting to 'java.lang.String'.", value));
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, String.class));
                } else {
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, type));
                }
            }
            parameterList.add((Object)parameterBuilder.getBeanDefinition());
        }
        return parameterList;
    }

    private JpaParserUtils() {
    }
}

